/*---------------------------------------------------------------------------

    QRSS Receiver Application
        
    by Clayton ZL3TKA/VK1TKA
    clayton@isnotcrazy.com

    Header File for GPS Module

---------------------------------------------------------------------------*/
#ifndef _GPS_H
#define _GPS_H

#include "mbed.h"

// Definitions

#define GPS_FIELDLEN        20
#define GPS_LINELENGTH      200
#define GPS_MSGTIMEOUT      3000        // GPS message timeout (mSecs)
#define GPS_PULSETIMEOUT    1500        // GPS pulse timeout (mSecs)

// comments

// Macros

//
// Classes
//

//---------------------------------------------------------------------------
//
//  GPS Module Class
//
class TGPSController
{
    // create/destroy
    public:
        TGPSController();
        ~TGPSController() {}

    // public type - GPS data
    public:
        typedef struct _gpsdata
        {
            int32_t     iGPSQuality;
            int32_t     iGPSSatellites;
            int32_t     iGPSTimeSeconds;
            int32_t     iGPSLatMicroDegrees;
            int32_t     iGPSLongMicroDegrees;
            int32_t     iGPSAltitudeMeters;
        } TGPSData;

    // local type - for parsing message numbers
    private:
        typedef struct _parsenumber
        {
            uint32_t    uiNumber;
            int         iNumberLen;
            int         iNumberSign;
            int         iNumberDecimals;
        } TParsedNum;

    // API
    public:
        // Initi8alise routine
        void Init();

        // Processing routine
        void Poll();

        // Return the last line from the GPS
        const char * LastLine()
            { return szLastLine; }
        
        // indicate a new last line has been received from the GPS unit
        //  Self resetting
        bool NewLine()
            {
                bool bRet = bNewLine;
                bNewLine = false;
                return bRet;
            }

        // Get GPS Data
        //  Returns status value (0=offline)
        int GPSData( TGPSData &GPSDat )
            { GPSDat = GPSRecord;
              return GPSDat.iGPSQuality; }

    // Private methods
    private:
        // callback on 1PPS rising edge
        void PPSPulse();

        // Parse a number
        bool ParseNumber( char cChr );
        void ResetNumber();

        // Parse data from the GPS
        //  Return true if a completed valid sentence is received
        bool ParseData( char cChr );

        //  Process the data from the GPS message
        //      Returns 0 if all data is good, or an error code
        //      Call after a valid ParseData has occurred
        int ProcessGPSData();

    // data
    private:
        // 1PPS pin
        DigitalIn   PPSInput;

        // GPS Serial Port
        Serial      GPSPort;
        
        // GPS Status LED
        DigitalOut  GPSUpLED;

        // Interrupt on 1PPS pulse
        InterruptIn PPSEvent;        
        
        // 1PPS flag and captured timer registers
        bool        bPulsed;
        uint32_t    uiPPSCapture;
        uint32_t    uiLOscCapture;

        // GPS data timeout timer
        Timer       GPSMsgTimeout;
        Timer       GPSPulseTimeout;

        // Parsing data and resulting values
        int         iParseState;
        TParsedNum  ParseNum;
        char        cCharacter;
        
        // last line variables
        char        szCurrentLine[GPS_LINELENGTH+1];
        char        szLastLine[GPS_LINELENGTH+1];
        bool        bNewLine;

        // GPS message data - raw data from message
        TParsedNum  GPSTime;
        TParsedNum  GPSLatitude;
        char        GPSLatNS;
        TParsedNum  GPSLongitude;
        char        GPSLongEW;
        TParsedNum  GPSQuality;
        TParsedNum  GPSSatellites;
        TParsedNum  GPSDOP;
        TParsedNum  GPSAltitude;
        char        GPSAltType;
        TParsedNum  GPSHeight;
        char        GPSHeightType;
        uint8_t     ucMsgChecksum;
        uint8_t     ucFinalChecksum;
        uint8_t     ucChecksum;

        // Final GPS info (validated)        
        TGPSData    GPSRecord;
};

// declare the GPS module
extern TGPSController GPSModule;

#endif

//---------------------------------------------------------------------------
//  END
//---------------------------------------------------------------------------

