/*---------------------------------------------------------------------------

    QRSS Receiver Application
        
    by Clayton ZL3TKA/VK1TKA
    clayton@isnotcrazy.com

    DSP Processing class

---------------------------------------------------------------------------*/
// include files

#include "DSP.h"

// Definitions

// Macros

// Local Data

// Global Data

// Function Prototypes


/*

    LP FIR Filter calculated from Web calculator
        http://www-users.cs.york.ac.uk/~fisher/cgi-bin/mkfscript

    Sample Rate:    35156
    Corner Freq:    200
    Taps:           511
    Beta:           0.5

// Digital filter designed by mkfilter/mkshape/gencode   A.J. Fisher
//  Command line: /www/usr/fisher/helpers/mkshape -c 5.6889293435e-03 5.0000000000e-01 511 -b 16 -l

#define NZEROS 510
#define GAIN   8.763528442e+01

static float xv[NZEROS+1];

static float xcoeffs[] =
  { +0.0006713867, +0.0008544922, +0.0010375977, +0.0012817383,
    +0.0015258789, +0.0017700195, +0.0020446777, +0.0023498535,
    +0.0026855469, +0.0030212402, +0.0033874512, +0.0037841797,
    +0.0041809082, +0.0046081543, +0.0050659180, +0.0055236816,
    +0.0060119629, +0.0065002441, +0.0070190430, +0.0075378418,
    +0.0080871582, +0.0086364746, +0.0092163086, +0.0097961426,
    +0.0103759766, +0.0109558105, +0.0115661621, +0.0121765137,
    +0.0127868652, +0.0133972168, +0.0140075684, +0.0146179199,
    +0.0151977539, +0.0158081055, +0.0163879395, +0.0169677734,
    +0.0175476074, +0.0180969238, +0.0186462402, +0.0191650391,
    +0.0196533203, +0.0201416016, +0.0205688477, +0.0209960938,
    +0.0213928223, +0.0217590332, +0.0220947266, +0.0223693848,
    +0.0226440430, +0.0228576660, +0.0230102539, +0.0231323242,
    +0.0232238770, +0.0232238770, +0.0232238770, +0.0231323242,
    +0.0229797363, +0.0227966309, +0.0225219727, +0.0222167969,
    +0.0218200684, +0.0213623047, +0.0208435059, +0.0202636719,
    +0.0195922852, +0.0188598633, +0.0180664062, +0.0171813965,
    +0.0162048340, +0.0151672363, +0.0140380859, +0.0128479004,
    +0.0115661621, +0.0102233887, +0.0087890625, +0.0072631836,
    +0.0056762695, +0.0039978027, +0.0022277832, +0.0003967285,
    -0.0015258789, -0.0035095215, -0.0055847168, -0.0077514648,
    -0.0099792480, -0.0122680664, -0.0146484375, -0.0170898438,
    -0.0195922852, -0.0221557617, -0.0248107910, -0.0274963379,
    -0.0302429199, -0.0330505371, -0.0359191895, -0.0388183594,
    -0.0417785645, -0.0447692871, -0.0477905273, -0.0508422852,
    -0.0539245605, -0.0570373535, -0.0601501465, -0.0632934570,
    -0.0664367676, -0.0695800781, -0.0727233887, -0.0758666992,
    -0.0789794922, -0.0820922852, -0.0851745605, -0.0881958008,
    -0.0912170410, -0.0941467285, -0.0970764160, -0.0999145508,
    -0.1026916504, -0.1054077148, -0.1080322266, -0.1105651856,
    -0.1130065918, -0.1153564453, -0.1175842285, -0.1197204590,
    -0.1217346191, -0.1235961914, -0.1253356934, -0.1269226074,
    -0.1283569336, -0.1296386719, -0.1307373047, -0.1316833496,
    -0.1324462891, -0.1329956055, -0.1333923340, -0.1335754394,
    -0.1335144043, -0.1332702637, -0.1328125000, -0.1321105957,
    -0.1311950684, -0.1300048828, -0.1286010742, -0.1269226074,
    -0.1250000000, -0.1228332519, -0.1203613281, -0.1176452637,
    -0.1146545410, -0.1113586426, -0.1077880859, -0.1039428711,
    -0.0997924805, -0.0953369141, -0.0906066895, -0.0855407715,
    -0.0802001953, -0.0745544434, -0.0686035156, -0.0623168945,
    -0.0557250977, -0.0488586426, -0.0416564941, -0.0341186523,
    -0.0263061523, -0.0181579590, -0.0097351074, -0.0009765625,
    +0.0080871582, +0.0174255371, +0.0270996094, +0.0370483398,
    +0.0473022461, +0.0578308105, +0.0686645508, +0.0797729492,
    +0.0911560059, +0.1028137207, +0.1147155762, +0.1268920898,
    +0.1393432617, +0.1520080566, +0.1649169922, +0.1780700684,
    +0.1914367676, +0.2050170898, +0.2188110352, +0.2327880859,
    +0.2469482422, +0.2613220215, +0.2758178711, +0.2904968262,
    +0.3053283691, +0.3203125000, +0.3353881836, +0.3505859375,
    +0.3659057617, +0.3812866211, +0.3967590332, +0.4122924805,
    +0.4279174805, +0.4435424805, +0.4591979981, +0.4748840332,
    +0.4905700684, +0.5062561035, +0.5219116211, +0.5375366211,
    +0.5531005859, +0.5686035156, +0.5840148926, +0.5993652344,
    +0.6145935059, +0.6296997070, +0.6446838379, +0.6595153809,
    +0.6741943359, +0.6886901855, +0.7030334473, +0.7171325684,
    +0.7310485840, +0.7447204590, +0.7581787109, +0.7713623047,
    +0.7843017578, +0.7969665527, +0.8093261719, +0.8214111328,
    +0.8331604004, +0.8446044922, +0.8557128906, +0.8664855957,
    +0.8768920898, +0.8869323730, +0.8966064453, +0.9058837891,
    +0.9147949219, +0.9232788086, +0.9313659668, +0.9390258789,
    +0.9462585449, +0.9530944824, +0.9594421387, +0.9653625488,
    +0.9708557129, +0.9758605957, +0.9804077148, +0.9844970703,
    +0.9880981445, +0.9912414551, +0.9938964844, +0.9960937500,
    +0.9977722168, +0.9989929199, +0.9997253418, +0.9999694824,
    +0.9997253418, +0.9989929199, +0.9977722168, +0.9960937500,
    +0.9938964844, +0.9912414551, +0.9880981445, +0.9844970703,
    +0.9804077148, +0.9758605957, +0.9708557129, +0.9653625488,
    +0.9594421387, +0.9530944824, +0.9462585449, +0.9390258789,
    +0.9313659668, +0.9232788086, +0.9147949219, +0.9058837891,
    +0.8966064453, +0.8869323730, +0.8768920898, +0.8664855957,
    +0.8557128906, +0.8446044922, +0.8331604004, +0.8214111328,
    +0.8093261719, +0.7969665527, +0.7843017578, +0.7713623047,
    +0.7581787109, +0.7447204590, +0.7310485840, +0.7171325684,
    +0.7030334473, +0.6886901855, +0.6741943359, +0.6595153809,
    +0.6446838379, +0.6296997070, +0.6145935059, +0.5993652344,
    +0.5840148926, +0.5686035156, +0.5531005859, +0.5375366211,
    +0.5219116211, +0.5062561035, +0.4905700684, +0.4748840332,
    +0.4591979981, +0.4435424805, +0.4279174805, +0.4122924805,
    +0.3967590332, +0.3812866211, +0.3659057617, +0.3505859375,
    +0.3353881836, +0.3203125000, +0.3053283691, +0.2904968262,
    +0.2758178711, +0.2613220215, +0.2469482422, +0.2327880859,
    +0.2188110352, +0.2050170898, +0.1914367676, +0.1780700684,
    +0.1649169922, +0.1520080566, +0.1393432617, +0.1268920898,
    +0.1147155762, +0.1028137207, +0.0911560059, +0.0797729492,
    +0.0686645508, +0.0578308105, +0.0473022461, +0.0370483398,
    +0.0270996094, +0.0174255371, +0.0080871582, -0.0009765625,
    -0.0097351074, -0.0181579590, -0.0263061523, -0.0341186523,
    -0.0416564941, -0.0488586426, -0.0557250977, -0.0623168945,
    -0.0686035156, -0.0745544434, -0.0802001953, -0.0855407715,
    -0.0906066895, -0.0953369141, -0.0997924805, -0.1039428711,
    -0.1077880859, -0.1113586426, -0.1146545410, -0.1176452637,
    -0.1203613281, -0.1228332519, -0.1250000000, -0.1269226074,
    -0.1286010742, -0.1300048828, -0.1311950684, -0.1321105957,
    -0.1328125000, -0.1332702637, -0.1335144043, -0.1335754394,
    -0.1333923340, -0.1329956055, -0.1324462891, -0.1316833496,
    -0.1307373047, -0.1296386719, -0.1283569336, -0.1269226074,
    -0.1253356934, -0.1235961914, -0.1217346191, -0.1197204590,
    -0.1175842285, -0.1153564453, -0.1130065918, -0.1105651856,
    -0.1080322266, -0.1054077148, -0.1026916504, -0.0999145508,
    -0.0970764160, -0.0941467285, -0.0912170410, -0.0881958008,
    -0.0851745605, -0.0820922852, -0.0789794922, -0.0758666992,
    -0.0727233887, -0.0695800781, -0.0664367676, -0.0632934570,
    -0.0601501465, -0.0570373535, -0.0539245605, -0.0508422852,
    -0.0477905273, -0.0447692871, -0.0417785645, -0.0388183594,
    -0.0359191895, -0.0330505371, -0.0302429199, -0.0274963379,
    -0.0248107910, -0.0221557617, -0.0195922852, -0.0170898438,
    -0.0146484375, -0.0122680664, -0.0099792480, -0.0077514648,
    -0.0055847168, -0.0035095215, -0.0015258789, +0.0003967285,
    +0.0022277832, +0.0039978027, +0.0056762695, +0.0072631836,
    +0.0087890625, +0.0102233887, +0.0115661621, +0.0128479004,
    +0.0140380859, +0.0151672363, +0.0162048340, +0.0171813965,
    +0.0180664062, +0.0188598633, +0.0195922852, +0.0202636719,
    +0.0208435059, +0.0213623047, +0.0218200684, +0.0222167969,
    +0.0225219727, +0.0227966309, +0.0229797363, +0.0231323242,
    +0.0232238770, +0.0232238770, +0.0232238770, +0.0231323242,
    +0.0230102539, +0.0228576660, +0.0226440430, +0.0223693848,
    +0.0220947266, +0.0217590332, +0.0213928223, +0.0209960938,
    +0.0205688477, +0.0201416016, +0.0196533203, +0.0191650391,
    +0.0186462402, +0.0180969238, +0.0175476074, +0.0169677734,
    +0.0163879395, +0.0158081055, +0.0151977539, +0.0146179199,
    +0.0140075684, +0.0133972168, +0.0127868652, +0.0121765137,
    +0.0115661621, +0.0109558105, +0.0103759766, +0.0097961426,
    +0.0092163086, +0.0086364746, +0.0080871582, +0.0075378418,
    +0.0070190430, +0.0065002441, +0.0060119629, +0.0055236816,
    +0.0050659180, +0.0046081543, +0.0041809082, +0.0037841797,
    +0.0033874512, +0.0030212402, +0.0026855469, +0.0023498535,
    +0.0020446777, +0.0017700195, +0.0015258789, +0.0012817383,
    +0.0010375977, +0.0008544922, +0.0006713867,
  };

static void filterloop()
  { for (;;)
      { float sum; int i;
        for (i = 0; i < NZEROS; i++) xv[i] = xv[i+1];
        xv[NZEROS] = next input value / GAIN;
        sum = 0.0;
        for (i = 0; i <= NZEROS; i++) sum += (xcoeffs[i] * xv[i]);
        next output value = sum;
      }
  }

*/

const int16_t aiFIRCoefficients[DSP_FIR_COEFFICIENTS] = {
        22,28,34,42,50,58,67,77,
        88,99,111,124,137,151,166,181,
        197,213,230,247,265,283,302,321,
        340,359,379,399,419,439,459,479,
        498,518,537,556,575,593,611,628,
        644,660,674,688,701,713,724,733,
        742,749,754,758,761,761,761,758,
        753,747,738,728,715,700,683,664,
        642,618,592,563,531,497,460,421,
        379,335,288,238,186,131,73,13,
        -50,-115,-183,-254,-327,-402,-480,-560,
        -642,-726,-813,-901,-991,-1083,-1177,-1272,
        -1369,-1467,-1566,-1666,-1767,-1869,-1971,-2074,
        -2177,-2280,-2383,-2486,-2588,-2690,-2791,-2890,
        -2989,-3085,-3181,-3274,-3365,-3454,-3540,-3623,
        -3703,-3780,-3853,-3923,-3989,-4050,-4107,-4159,
        -4206,-4248,-4284,-4315,-4340,-4358,-4371,-4377,
        -4375,-4367,-4352,-4329,-4299,-4260,-4214,-4159,
        -4096,-4025,-3944,-3855,-3757,-3649,-3532,-3406,
        -3270,-3124,-2969,-2803,-2628,-2443,-2248,-2042,
        -1826,-1601,-1365,-1118,-862,-595,-319,-32,
        265,571,888,1214,1550,1895,2250,2614,
        2987,3369,3759,4158,4566,4981,5404,5835,
        6273,6718,7170,7628,8092,8563,9038,9519,
        10005,10496,10990,11488,11990,12494,13001,13510,
        14022,14534,15047,15561,16075,16589,17102,17614,
        18124,18632,19137,19640,20139,20634,21125,21611,
        22092,22567,23037,23499,23955,24403,24844,25276,
        25700,26115,26520,26916,27301,27676,28040,28393,
        28734,29063,29380,29684,29976,30254,30519,30770,
        31007,31231,31439,31633,31813,31977,32126,32260,
        32378,32481,32568,32640,32695,32735,32759,32767,
        32759,32735,32695,32640,32568,32481,32378,32260,
        32126,31977,31813,31633,31439,31231,31007,30770,
        30519,30254,29976,29684,29380,29063,28734,28393,
        28040,27676,27301,26916,26520,26115,25700,25276,
        24844,24403,23955,23499,23037,22567,22092,21611,
        21125,20634,20139,19640,19137,18632,18124,17614,
        17102,16589,16075,15561,15047,14534,14022,13510,
        13001,12494,11990,11488,10990,10496,10005,9519,
        9038,8563,8092,7628,7170,6718,6273,5835,
        5404,4981,4566,4158,3759,3369,2987,2614,
        2250,1895,1550,1214,888,571,265,-32,
        -319,-595,-862,-1118,-1365,-1601,-1826,-2042,
        -2248,-2443,-2628,-2803,-2969,-3124,-3270,-3406,
        -3532,-3649,-3757,-3855,-3944,-4025,-4096,-4159,
        -4214,-4260,-4299,-4329,-4352,-4367,-4375,-4377,
        -4371,-4358,-4340,-4315,-4284,-4248,-4206,-4159,
        -4107,-4050,-3989,-3923,-3853,-3780,-3703,-3623,
        -3540,-3454,-3365,-3274,-3181,-3085,-2989,-2890,
        -2791,-2690,-2588,-2486,-2383,-2280,-2177,-2074,
        -1971,-1869,-1767,-1666,-1566,-1467,-1369,-1272,
        -1177,-1083,-991,-901,-813,-726,-642,-560,
        -480,-402,-327,-254,-183,-115,-50,13,
        73,131,186,238,288,335,379,421,
        460,497,531,563,592,618,642,664,
        683,700,715,728,738,747,753,758,
        761,761,761,758,754,749,742,733,
        724,713,701,688,674,660,644,628,
        611,593,575,556,537,518,498,479,
        459,439,419,399,379,359,340,321,
        302,283,265,247,230,213,197,181,
        166,151,137,124,111,99,88,77,
        67,58,50,42,34,28,22
        };

/*
    Sin table to convert NCO phase to Oscillator outputs
*/
const int16_t aiSinTable[256] = {
        0,6,13,19,25,31,37,44,
        50,56,62,68,74,80,86,92,
        98,103,109,115,120,126,131,136,
        142,147,152,157,162,167,171,176,
        180,185,189,193,197,201,205,208,
        212,215,219,222,225,228,231,233,
        236,238,240,242,244,246,247,249,
        250,251,252,253,254,254,255,255,
        255,255,255,254,254,253,252,251,
        250,249,247,246,244,242,240,238,
        236,233,231,228,225,222,219,215,
        212,208,205,201,197,193,189,185,
        180,176,171,167,162,157,152,147,
        142,136,131,126,120,115,109,103,
        98,92,86,80,74,68,62,56,
        50,44,37,31,25,19,13,6,
        0,-6,-13,-19,-25,-31,-37,-44,
        -50,-56,-62,-68,-74,-80,-86,-92,
        -98,-103,-109,-115,-120,-126,-131,-136,
        -142,-147,-152,-157,-162,-167,-171,-176,
        -180,-185,-189,-193,-197,-201,-205,-208,
        -212,-215,-219,-222,-225,-228,-231,-233,
        -236,-238,-240,-242,-244,-246,-247,-249,
        -250,-251,-252,-253,-254,-254,-255,-255,
        -255,-255,-255,-254,-254,-253,-252,-251,
        -250,-249,-247,-246,-244,-242,-240,-238,
        -236,-233,-231,-228,-225,-222,-219,-215,
        -212,-208,-205,-201,-197,-193,-189,-185,
        -180,-176,-171,-167,-162,-157,-152,-147,
        -142,-136,-131,-126,-120,-115,-109,-103,
        -98,-92,-86,-80,-74,-68,-62,-56,
        -50,-44,-37,-31,-25,-19,-13,-6 
        };

//---------------------------------------------------------------------------
//  LOCAL FUNCTIONS
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//
//  Perform a MAC Operation (multiply and Accumulate)
//      Assumes data is from samples structure, so skips every 2nd sample
//      Produces a 64 bit result
//
int64_t MAC_Samples( int64_t llSum, const int32_t *piSamples, const int16_t *piCoefficients, int iCnt )
{
    int64_t llMult;
    
    while ( iCnt>0 )
    {
        llMult = *piSamples;
        llMult *= *piCoefficients;
        llSum += llMult;
        piSamples++;
        piSamples++;    // skip other sample pair
        piCoefficients++;
        iCnt--;
    }
    return llSum;
}

//---------------------------------------------------------------------------
//
//  Convert a 64 bit sum to a 32 bit output
//
int32_t ConvertToOutput( int64_t llSum )
{
    return (int32_t)(llSum>>FIR_SHIFT_FACTOR);
}

//---------------------------------------------------------------------------
//  DSP Methods
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//
//  Set up NCO Increment from a frequency value
//
void TDSPProcessor::NCOFrequency( int32_t iFreq )
{
    int64_t     llFreq;
    int64_t     llInc;

    // Inc (32bit) = Freq * 2^32 / SampleRate
    // Use long long (64 bit int) for calculations to prevent overflow and get best resolution
    llFreq = iFreq;
    llInc = llFreq * 0x10000 * 0x10000 / SAMPLE_RATE;
    // Convert back to 32 bit unsigned via integer type
    uiMixerPhaseIncrement = (uint32_t)((int32_t)llInc);
    printf( "LO Freq set to %d - NCO Inc set to %u\r\n", iFreq, uiMixerPhaseIncrement );
}


//---------------------------------------------------------------------------
//
//  Reset processing
//
void TDSPProcessor::Reset()
{
    uiMixerPhaseAccumulator = 0;
    bLPFPartailsValid = false;
    Release();
}

//---------------------------------------------------------------------------
//
//  Mix samples with LO (local oscillator)
//
bool TDSPProcessor::MixLO()
{
    int ii;
    int iLen = Length();
    TDataSample * pSample;
    int16_t     iIlo;
    int16_t     iQlo;
    int32_t     iIin;
    int32_t     iQin;

    for ( ii=0,pSample=SamplePtr(); ii<iLen; ii++,pSample++ )
    {
        // generate quadrature oscillators. LO I=cos Q=sin
        iIlo = aiSinTable[ (64+(uiMixerPhaseAccumulator>>24))&0xFF ];     // COS
        iQlo = aiSinTable[ (uiMixerPhaseAccumulator>>24) ];               // SIN
        // inc NCO
        uiMixerPhaseAccumulator += uiMixerPhaseIncrement;
        // scale samples (they are only 24 bits)
        iIin = pSample->iIData / 256;
        iQin = pSample->iQData / 256;
        // complex multiply sample and LO
        // (A + Bi) * (C + Di) = (AC - BD) + (BC + AD)i
        pSample->iIData = (iIin * iIlo) - (iQin * iQlo);
        pSample->iQData = (iQin * iIlo) + (iIin * iQlo);
    }

    return true;
}

//---------------------------------------------------------------------------
//
//  LPF processing
//
bool TDSPProcessor::LPF()
{
/*
    We just code this up for the parameters defined.
    It could be dynamically coded, but for simplicity hard-coding will be used
*/
#if (BUFFERSYS_SIZE!=512)
  #error BUFFERSYS_SIZE has changed from 512
#endif
#if (DSP_FIR_COEFFICIENTS!=511)
  #error DSP_FIR_COEFFICIENTS has changed from 511
#endif
#if (DECIMATION_RATIO!=64)
  #error DECIMATION_RATIO has changed from 64
#endif
#if (LPF_OUTPUTS_SIZE!=8)
  #error LPF_OUTPUTS_SIZE has changed from 8
#endif

    int64_t     iSum;
    int         ii;
    bool        bRet = false;

    // Outputs
    if ( bLPFPartailsValid )
    {
        for ( ii=0; ii<8; ii++ )
        {
            iSum = MAC_Samples( asLPFPartials[ii].iIData, &(SamplePtr(0)->iIData), &(aiFIRCoefficients[448-(ii*64)]), (ii*64)+62 );
            asLPFOutputs[ii].iIData = ConvertToOutput( iSum );
            iSum = MAC_Samples( asLPFPartials[ii].iQData, &(SamplePtr(0)->iQData), &(aiFIRCoefficients[448-(ii*64)]), (ii*64)+62 );
            asLPFOutputs[ii].iQData = ConvertToOutput( iSum );
        }
        bRet = true;
    }
    // Partials
    for ( ii=0; ii<7; ii++ )
    {
        asLPFPartials[ii].iIData = MAC_Samples( 0, &(SamplePtr((ii*64)+64)->iIData), &(aiFIRCoefficients[0]), (7-ii)*64 );
        asLPFPartials[ii].iQData = MAC_Samples( 0, &(SamplePtr((ii*64)+64)->iQData), &(aiFIRCoefficients[0]), (7-ii)*64 );
    }
    // Partials[7] = 0
    asLPFPartials[7].iIData = 0;
    asLPFPartials[7].iQData = 0;
    bLPFPartailsValid = true;

    return bRet;
}

//---------------------------------------------------------------------------
//  END
//---------------------------------------------------------------------------
