/*---------------------------------------------------------------------------

    QRSS Receiver Application
        
    by Clayton ZL3TKA/VK1TKA
    clayton@isnotcrazy.com

    Header File for DSP Processing class

---------------------------------------------------------------------------*/
#ifndef _DSP_H
#define _DSP_H

#include "mbed.h"
#include "BufferSys.h"

// Definitions

// Macros

//
// Classes
//

//---------------------------------------------------------------------------
//
//  DSP Processor Class - based on a buffer handle. Processes the attached samples buffer
//
class TDSPProcessor : public TBufferHandle
{

    // parameters
    public:
        // Set NCO phase inc
        //  Set inc directly
        void NCOPhaseInc( uint32_t uiPhaseInc )
            { uiMixerPhaseIncrement = uiPhaseInc; }
        // Set inc from a frequency
        void NCOFrequency( int32_t iFreq );

    // results
    public:
        // get filtered output data
        const TDataSample FilteredOutput( int iIndex ) const
        {
            if ( !HasBuffer() || (iIndex<0) || (iIndex>=LPF_OUTPUTS_SIZE) )
                return NullSample;  // return empty sample
            return asLPFOutputs[iIndex];
        }

    // processing operations
    public:
        // Reset processing
        void Reset();

        // Mix samples with LO
        bool MixLO();
        
        // LPF processing
        bool LPF();

    // data
    protected:
        // NCO mixer
        uint32_t        uiMixerPhaseAccumulator;
        uint32_t        uiMixerPhaseIncrement;

        // LPF outputs
        TDataSample     asLPFOutputs[LPF_OUTPUTS_SIZE];
        
        // LPF partial results (ready to complete with the next buffer)
        TLongDataSample asLPFPartials[LPF_OUTPUTS_SIZE];
        
        // LPF Partials valid flag
        bool            bLPFPartailsValid;
        
};

#endif

//---------------------------------------------------------------------------
//  END
//---------------------------------------------------------------------------

