/*---------------------------------------------------------------------------

    QRSS Receiver Application
        
    by Clayton ZL3TKA/VK1TKA
    clayton@isnotcrazy.com

    Header File for global definitions

---------------------------------------------------------------------------*/
#ifndef _GLOBAL_H
#define _GLOBAL_H

// Definitions

// Size of data buffers (in samples)
#define BUFFERSYS_SIZE          512

// Number of buffers
#define NUM_OF_BUFFERS          4

// Number of co-efficients in the FIR filter
#define DSP_FIR_COEFFICIENTS    511

// ADC Clock (13.5MHz)
#define ADC_CLOCK               13500000

// Sample Rate (35156 SPS)
#define SAMPLE_RATE             (ADC_CLOCK/384)

// Decimation amount - ratio
#define DECIMATION_RATIO        64

// Size of LPF output per Buffer
//  (BUFFERSYS_SIZE/DECIMATION_RATIO)
#define LPF_OUTPUTS_SIZE        8

// Decimation Rate (35156/64 = 549 SPS)
#define DECIMATED_RATE          (SAMPLE_RATE/DECIMATION_RATIO)

// Scale Factor rate of FIR filter result to output sample
// 32 bit sample * 16 bit coefficient * 511 scaled down to 32 bits
//  32+16+9 bits = 57. Reduce by 25
#define FIR_SHIFT_FACTOR        25

// First LO in the Softrock (10.125MHz)
#define FIRST_LO                (ADC_CLOCK*3/4)

// Test NCO freq - approx 15kHz
#define TEST_NCO_FREQ           (15600)

// Size of each sample set in bytes - size of TDataSample
#define SAMPLE_SET_SIZE         (8)

// QRSS System UDP Port
#define QRSS_UDP_PORT           6595

// comments

// Macros

#endif

//---------------------------------------------------------------------------
//  END
//---------------------------------------------------------------------------

