/*---------------------------------------------------------------------------

    QRSS Receiver Application
        
    by Clayton ZL3TKA/VK1TKA
    clayton@isnotcrazy.com
    
    Buffer System

---------------------------------------------------------------------------*/
// include files

#include "BufferSys.h"

// Definitions

// Macros

// Local Data

// Global Data
const TDataSample NullSample = {0,0};

// Function Prototypes

//---------------------------------------------------------------------------
//  BUFFER SYSTEM METHODS
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//
//  Buffer Release Method
//
void TBufferHandle::Release( void )
{
    if ( !HasBuffer() )
        return;
    // If the handler was the only reference to the buffer
    //  then the buffer should be released to the pool
    if ( pMyBuffer->iRefCount<=0 )
         error( "TBufferHandle::CheckForBuffer Invalid TBufferData iRefCount in Release - %d\r\n", pMyBuffer->iRefCount );
    pMyBuffer->iRefCount--;
    if ( pMyBuffer->iRefCount==0 )
    {   // Release message to the pool it came from
        pMyBuffer->pPool->ReturnToPool( pMyBuffer );
    } 
    // Detach the message from the handler
    pMyBuffer = NULL;
}

//---------------------------------------------------------------------------
//  END
//---------------------------------------------------------------------------
