#include "mbed.h"
#include "nRF24L01P.h"
#include "FXOS8700Q.h"
#include "DebounceIn.h"

#define ACC_SAMPLE_SIZE 200
#define ACC_X_GAIN 1
#define ACC_Y_GAIN 2
#define TRANSFER_SIZE   9

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD6, PTD7, PTD5, PTD4, PTC12, PTC18);    // mosi, miso, sck, csn, ce, irq
FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // Proper Ports and I2C Address for K64F Freedom board

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
MotionSensorDataCounts acc_raw;
int16_t acc_x, acc_y;
DebounceIn fire_button(PTA4);
DebounceIn cal_button(PTC6);

int main() {

    char txData[TRANSFER_SIZE];
    int txDataCnt = 0;

    int acc_x_array[ACC_SAMPLE_SIZE];
    int acc_y_array[ACC_SAMPLE_SIZE];
    int acc_sample_cnt = 0;

    int acc_x_avg = 0;
    int acc_y_avg = 0;
    
    int acc_x_cal = 0;
    int acc_y_cal = 0;

    pc.baud(115200);
    
    my_nrf24l01p.setTxAddress(0xDEADBEEF01);
    my_nrf24l01p.powerUp();
    myled1 = 1;
    myled2 = 1;
    
    // Display the setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.enable();

    acc.enable();
    
    myled3 = 0;
    
    for (int x=0; x<ACC_SAMPLE_SIZE; x++) {
        acc_x_array[x]=0;
        acc_y_array[x]=0;
    }
    
    while (1) {
        acc.getAxis(acc_raw);
        
        acc_x = acc_raw.x - acc_x_cal;
        acc_y = acc_raw.y - acc_y_cal;

        acc_x_array[acc_sample_cnt]=(int)(acc_x>>2);
        acc_y_array[acc_sample_cnt]=(int)(acc_y>>2);

        acc_sample_cnt++;
        if (acc_sample_cnt>=ACC_SAMPLE_SIZE) acc_sample_cnt = 0;

        acc_x_avg=0;
        acc_y_avg=0;
        for (int x=0; x<ACC_SAMPLE_SIZE; x++) {
            acc_x_avg=acc_x_avg+acc_x_array[x];
            acc_y_avg=acc_y_avg+acc_y_array[x];
        }
        acc_x_avg = (int)(acc_x_avg/ACC_SAMPLE_SIZE);
        acc_y_avg = (int)(acc_y_avg/ACC_SAMPLE_SIZE);

        //pc.printf("%d (%d)\t%d (%d)\n\r",acc_x_avg,acc_raw.x,acc_y_avg,acc_raw.y);

        txData[0] = (acc_x_avg) & 0xff;
        txData[1] = (acc_x_avg>>8)  & 0xff;
        txData[2] = (acc_x_avg>>16)  & 0xff;
        txData[3] = (acc_x_avg>>24)  & 0xff;
    
        txData[4] = (acc_y_avg) & 0xff;
        txData[5] = (acc_y_avg>>8)  & 0xff;
        txData[6] = (acc_y_avg>>16)  & 0xff;
        txData[7] = (acc_y_avg>>24)  & 0xff;
        
        txData[8] = (char)(fire_button.read());
        myled1 = fire_button.read();
        myled3 = !myled1;
        
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, sizeof( txData ) );
        
        wait(0.001);
        
        if (cal_button.read()==0) {
            myled2 = 0;
            myled3 = 1;
            
            acc_x_avg=0;
            acc_y_avg=0;
            for (int x=0; x<ACC_SAMPLE_SIZE; x++) {
                acc.getAxis(acc_raw);
                acc_x_avg=acc_x_avg+acc_raw.x;
                acc_y_avg=acc_y_avg+acc_raw.y;
                wait(0.01);
            }
            acc_x_cal = (int)(acc_x_avg/ACC_SAMPLE_SIZE);
            acc_y_cal = (int)(acc_y_avg/ACC_SAMPLE_SIZE);
            myled2 = 1;
            myled3 = 0;
        }
    
    }
}
