#include "mbed.h"

DigitalOut gpo(D12);  // Output pin for lights
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalOut led_blue(LED_BLUE);

#define AL 18 // Array Length
#define NB 50 // Number of Bulbs
#define LUM 0xFF // Brightness

//Example RGB Color Array (18)
unsigned int rval[AL] = {0xF,0xF,0xF,0xF,0xA,0x8,0x6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x8,0xA};
unsigned int gval[AL] = {0x0,0x0,0x0,0x0,0x6,0x8,0xA,0xF,0xF,0xF,0xA,0x8,0x6,0x0,0x0,0x0,0x0,0x0};
unsigned int bval[AL] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x8,0xA,0xF,0xF,0xA,0x8,0x6};

// GPIO output to send a logical 0
void s0()
{
    gpo=0;
    wait_us(10);
    gpo=1;
    wait_us(20);
}

// GPIO output to send a logical 1
void s1()
{
    gpo=0;
    wait_us(20);
    gpo=1;
    wait_us(10);
}

// GPIO output to send an "End of Frame" marker
void end_frame()
{
    gpo=0;
    wait_us(30);
}

// Parse data value to serial process 0/1's
void sdata(unsigned int data, int length)
{
    unsigned int data_bit;

    for (int i=(length-1); i>=0; i--) {
        data_bit = (data>>i)&0x01;
        if (data_bit==0) {
            s0();
        } else if (data_bit==1) {
            s1();
        }
    }
}

// Send frame of data to control a single pixel
void sframe(int channel, unsigned int lumm, unsigned int R, unsigned int G, unsigned int B)
{
// Send "1" value to start Frame
    s1();
// Send Address
    sdata(channel,6);
// Send Luminosity
    sdata(lumm,8);
// Send Blue 4-bits
    sdata(B,4);
// Send Green 4-bits
    sdata(G,4);
// Send Red 4-bits
    sdata(R,4);
// Send End of Frame Marker
    end_frame();
}

int main()
{
    led_red=1;
    led_green=1;
    led_blue=1;
    gpo=0;

    wait_ms(1000);

    // Initialize the light addresses (required after initially powering lights)
    for (int i=0; i<=NB; i++) {
        sframe(i,0,0,0,0);
    }

    // Example light sequence
    while(1) {
        for (int i=0; i<AL; i++) {
            for (int j=0; j<NB; j++) {
                sframe(j,LUM,rval[(i+j)%AL],gval[(i+j)%AL],bval[(i+j)%AL]);
            }
            wait_ms(10);
        }
    }
}