
#ifndef UTILITIES_H_INCLUDED
#define UTILITIES_H_INCLUDED

#include "mbed.h"

namespace utils {
    // From http://playground.arduino.cc/Main/Smooth
    /*Details: Smooth takes three parameters, the value to smoothed, the filter value (filterVal), and smoothedVal.
    
     float  sensVal - the sensor variable - raw material to be smoothed
    
     float  filterVal - The filter value is a float and must be between 0 and .9999 say. 0 is off (no smoothing) and .9999 is maximum smoothing.
     The actual performance of the filter is going to be dependent on fast you are sampling your sensor (the total loop time), so 
     some trial and error will probably be necessary to get the desired response.
    
     smoothedVal    -  Use this for the output of the sensor and also feed it back into the loop. Each sensor needs its own value.
     Don't use this variable for any other purpose.*/
    float smooth(float data, float filterVal, float smoothedVal);
    
    float min(float a, float b);
    
    void printBits(char myByte, Serial &pc);
} // end utils namespace


#endif  // End include guard