#ifndef RGBA_LED_H
#define RGBA_LED_H

#include "RGBA.h"
#include "PCA9634.h"
#include "colors.h"
#include "defines.h"
#include "mbed.h"
#include "math.h"
#include <vector>
#include <string>

class RGBA_LED
{
public:
    RGBA_LED(I2C *i2c, DigitalOut *inv_out_en, int addr, bool amber_enabled);
    
    void disableAmber();
    void disableAmber(int stripID);
    void enableAmber();
    void enableAmber(int stripID);
    
    void setColor(RGBA<float> color);
    void setColor(RGBA<float> color, int stripID);
    void setBrightness(float alpha);
    void setBrightness(float alpha, int stripID);
    
    // TODO
    void fadeColor(RGBA<float>, int duration);
    void fadeColor(RGBA<float>, int duration, int stripID);
    void fadeBrightness(float alpha, int duration);
    void fadeBrightness(float alpha, int duration, int stripID);
    
    void setDefaultColorFadeTime(int def_color_fade_time);
    void setDefaultBrightnessFadeTime(int def_alpha_fade_time);
    void setStepTime(int step_time);    // TODO
    int getStepTime();
    void step();
    
    // TODO
    void turnOn();
    void turnOn(int stripID);
    void turnOff();
    void turnOff(int stripID);
    
    // TODO
    //void setColorProgram(int preset_id, bool fadeInto);
    //void setColorProgram(int preset_id, int stripID, bool fadeInto);
    void setColorProgram(vector<RGBA<float> > color_program, vector<float> time_program, bool fadeInto);
    void setColorProgram(vector<RGBA<float> > color_program, vector<float> time_program, int stripID, bool fadeInto);
    //void setBrightnessProgram(int preset_id, bool fadeInto);
    //void setBrightnessProgram(int preset_id, int stripID, bool fadeInto);
    void setBrightnessProgram(vector<float> alpha_program, vector<float> time_program, bool fadeInto);
    void setBrightnessProgram(vector<float> alpha_program, vector<float> time_program, int stripID, bool fadeInto);
    
    RGBA<float> getPresetColor(char colorID);
    vector<RGBA<float> > getPresetColorProgram(int programID);
    //vector<RGBA<float> > genColorProgram(string sequence);
    //vector<RGBA<float> > genDoubleColorProgram(vector<RGBA<float> > colorProgram);    // Dublicates each color in sequence
    //vector<RGBA<float> > genHalfColorProgram(vector<RGBA<float> > colorProgram);      // For undoing genDoubleColorProgram
    vector<float> getPresetAlphaProgram(int programID);
    //vector<float> genFadeAlphaProgram(float duration);    // For simple fading without breaks
    //vector<float> genDelayedFadeAlphaProgram(float duration1, float duration2);   // For fading while staying at each color for a while

private:
    PCA9634 *led_driver_;

    RGBA<ledID> strip_leds_[2];      // Contains ids of LEDs associated with strips
    
    RGBA<float> cur_color_[2], dcolor_[2];   // Colors range from 0 to 255
    float cur_alpha_[2], dalpha_[2];         // Brightness ranges from 0.0 to 1.0
    
    int count_color_[2], count_alpha_[2];
    int ind_color_program_[2], ind_alpha_program_[2];
    int step_time_;                     // In milliseconds
    float def_color_fade_time_, def_alpha_fade_time_;
    
    vector<RGBA<float> > color_program_[2];
    vector<float> alpha_program_[2];
    vector<float> color_time_program_[2], alpha_time_program_[2];
    
    void updatePWMs();
    void updatePWMs(int stripID);
    
};



#endif