
#include "PCA9634.h"

PCA9634::PCA9634(I2C *i2c, DigitalOut *inv_out_en, int addr)
: i2c_(i2c), inv_out_en_(inv_out_en), addr_(addr) {
    *inv_out_en_ = 0;
    
    // Set Mode 1: Auto-increment on, oscillator on, do not respond to all-call
    writeReg(PCA9634_REG_MODE1, 0x80);
    // Set Mode 2: Don't invert logic, outputs change on ACK, LED outputs configured
    // in open-drain structure
    writeReg(PCA9634_REG_MODE2, 0x09);
    dimLEDs();
    // Set all LED driver output states to PWM
    led_out_state_[0] = PCA9634_ALL_LED_TO_PWM;
    led_out_state_[1] = PCA9634_ALL_LED_TO_PWM;
    
    commandLEDOutState();
}

void PCA9634::dimLEDs() {
    for (char reg = PCA_LED0; reg <= PCA_LED7; reg++)
        writeReg(reg, 0);
}

void PCA9634::disableLED(ledID led) {
    // Set correct registers to 00
    if (led < LED4) {
        led_out_state_[0] &= ~(1UL << (2*(led-2)));
        led_out_state_[0] &= ~(1UL << (2*(led-2)+1));
    } else {
        led_out_state_[1] &= ~(1UL << (2*(led-6)));
        led_out_state_[1] &= ~(1UL << (2*(led-6)+1));
    }
    commandLEDOutState();
}

void PCA9634::enableLED(ledID led) {
    // Set correct registers to 01
    if (led < LED4) {
        led_out_state_[0] |= (1UL << (2*(led-2)));
        led_out_state_[0] &= ~(1UL << (2*(led-2)+1));
    } else {
        led_out_state_[1] |= (1UL << (2*(led-6)));
        led_out_state_[1] &= ~(1UL << (2*(led-6)+1));
    }
    commandLEDOutState();
}

void PCA9634::commandLEDOutState() {
    writeReg(PCA9634_REG_LEDOUT0, led_out_state_[0]);
    writeReg(PCA9634_REG_LEDOUT1, led_out_state_[1]);   
}

void PCA9634::commandLEDBrightness(ledID led, int brightness) {
    writeReg(led, (char) brightness);
}

int PCA9634::writeReg(char reg, char value) {
    char cmd[2];
    cmd[0] = reg;
    cmd[1] = value;
    return i2c_->write(addr_, cmd, 2);
}