//
// Title        : Sieve of Eratosthenes
// Author       : Claus Kuehnel
// Date         : 2016-02-16
// Id           : sieve_ARCH_PRO
// based on     : sieve.pde from 2010
//
// DISCLAIMER:
// The author is in no way responsible for any problems or damage caused by
// using this code. Use at your own risk.
//
// LICENSE:
// This code is distributed under the GNU Public License
// which can be found at http://www.gnu.org/licenses/gpl.txt
//

#include "mbed.h"

#define TRUE 1
#define FALSE 0

int i,k, prime,count;

const int SIZE = 1000;    
char flags[SIZE+1];

Serial pc(USBTX, USBRX);
Timer timer;

DigitalOut myled(LED1);

int main() 
{
  myled = 0;
  pc.baud(115200);
  pc.printf("Sieve of Eratosthenes - Arch Pro\n");
  
  /*-------------------------------------------------------------------
  The following code is an implementation of the Sieve of Eratosthenes.
  -------------------------------------------------------------------*/
  pc.printf("5000 iterations\n");
  timer.start();
  unsigned long time = timer.read_ms();
  for (unsigned int iter = 1; iter <= 5000; iter++)     /* do program 5000 times */
  { 
    count = 0;                       /* initialize prime counter */
    for (i = 0; i <= SIZE; i++)      /* set all flags true */
      flags[i] = TRUE;
    for (i = 0; i <= SIZE; i++)
    {
      if (flags[i])                  /* found a prime */
      {
    prime = i + i + 3;               /* twice index + 3 */
    for (k = i + prime; k <= SIZE; k += prime)
      flags[k] = FALSE;              /* kill all multiples */
    count++;                         /* primes found */
      }
    }
  }
  myled = 1;
  time = timer.read_ms() - time;
  pc.printf("%d primes.\n", count);        
  pc.printf("Runtime = %d ms\n",time);
} 
