#include "mbed.h"
#include "uLCD_4DGL.h"
#include "MMA8452.h"
#include "Speaker.h"
#include "PinDetect.h"

#ifndef FARKLE_ASSISTANT_H
#define FARKLE_ASSISTANT_H


class Dice {
    private:
        int value;
        int x1, x2, y1, y2;
        
    public:
        Dice(){}
        
        Dice(int val)
         : value(val) {}
        
        int getValue(){return value;}
        
        void setValue(int val){value = val;}
        
        void displayDice(int position);
};

class FarkleGame {
    private:
        Dice arrayDice[6];
        int values[6];
        int count[6];
        int rollScore; 
        int totalScore;
        int numDie;
        int sub;
        double x, y, z;
        int oneC, twoC, threeC, fourC, fiveC, sixC;
    public:
        FarkleGame(){}
        void setNumDie(int num){numDie = num;}
        
        void setTotalScore(int tot){totalScore = tot;}
        
        void runFarkle();
        
        void rollDice();
        
        void calcRoll();
        
        void displayScore();
        
        void takeAway();
};

#endif