#include "mbed.h"
#include "farkle_assistant.h"

uLCD_4DGL myLCD(p9, p10, p11);
Speaker mySpeaker(p21);
PinDetect pb1(p19);
PinDetect pb2(p18);
PinDetect pb3(p17);
Serial pc(USBTX,USBRX);


void Dice::displayDice(int position) {
    if (position < 4) {
        y1 = 1, y2 = 43;
        x1 = 1 + ((position - 1) * 42);
        x2 = 1 + (position * 42);
    } else {
        y1 = 43, y2 = 85;
        x1 = 1 + ((position - 4) * 42);
        x2 = 1 + ((position - 3) * 42);
    }
    myLCD.filled_rectangle(x1, y1, x2, y2, DGREY);
    myLCD.rectangle(x1, y1, x2, y2, WHITE);
    if (value == 1) {
        myLCD.filled_circle(x1 + 21, y1 + 21, 3, WHITE);
    }else if (value == 2) {
        myLCD.filled_circle(x1 + 11, y1 + 11, 3, WHITE);
        myLCD.filled_circle(x2 - 11, y2 - 11, 3, WHITE);
    }else if (value == 3) {
        myLCD.filled_circle(x1 + 21, y1 + 21, 3, WHITE);
        myLCD.filled_circle(x1 + 11, y1 + 11, 3, WHITE);
        myLCD.filled_circle(x2 - 11, y2 - 11, 3, WHITE);
    }else if (value == 4) {
        myLCD.filled_circle(x1 + 11, y1 + 11, 3, WHITE);
        myLCD.filled_circle(x2 - 11, y2 - 11, 3, WHITE);
        myLCD.filled_circle(x2 - 11, y1 + 11, 3, WHITE);
        myLCD.filled_circle(x1 + 11, y2 - 11, 3, WHITE);
    }else if (value == 5) {
        myLCD.filled_circle(x1 + 11, y1 + 11, 3, WHITE);
        myLCD.filled_circle(x2 - 11, y2 - 11, 3, WHITE);
        myLCD.filled_circle(x2 - 11, y1 + 11, 3, WHITE);
        myLCD.filled_circle(x1 + 11, y2 - 11, 3, WHITE);
        myLCD.filled_circle(x1 + 21, y1 + 21, 3, WHITE);
    }else {
        myLCD.filled_circle(x1 + 11, y1 + 11, 3, WHITE);
        myLCD.filled_circle(x2 - 11, y2 - 11, 3, WHITE);
        myLCD.filled_circle(x2 - 11, y1 + 11, 3, WHITE);
        myLCD.filled_circle(x1 + 11, y2 - 11, 3, WHITE);
        myLCD.filled_circle(x1 + 11, y1 + 21, 3, WHITE);
        myLCD.filled_circle(x2 - 11, y2 - 21, 3, WHITE);
    }
}

void FarkleGame::runFarkle() {
    myLCD.cls();
    myLCD.color(WHITE);
    myLCD.text_width(2);
    myLCD.text_height(2);
    myLCD.locate(0,1);
    myLCD.printf("Shake\n");
    myLCD.printf("Board\n");
    myLCD.printf("------\n");
    myLCD.printf("To\n");
    myLCD.printf("Roll\n");
    myLCD.printf("%d Dice\n", numDie);
    rollDice();
}

void FarkleGame::rollDice() {
    pb2.mode(PullUp);
    int n = 0;
    x = 0;
    y = 0;
    z = 0;
    
    MMA8452 acc(p28, p27, 40000);
    acc.setBitDepth(MMA8452::BIT_DEPTH_12);
    acc.setDynamicRange(MMA8452::DYNAMIC_RANGE_4G);
    acc.setDataRate(MMA8452::RATE_100);
    while (n == 0) {
        acc.readXYZGravity(&x,&y,&z);
        if (pb2 == false) {
            mySpeaker.PlayNote(400, 0.15, 0.05);
            numDie = ((numDie + 1)%7);
            runFarkle();
        }else if ((x*x + y*y + z*z) > 2) {
            mySpeaker.PlayNote(600, 0.15, 0.05);
            mySpeaker.PlayNote(700, 0.15, 0.05);
            mySpeaker.PlayNote(800, 0.15, 0.05);
            mySpeaker.PlayNote(600, 0.15, 0.05);
            myLCD.cls();
            for (int i = 0; i < numDie; i++) {
                values[i] = (rand() % 6) + 1;
                Dice dicen(values[i]);
                arrayDice[i] = dicen;
                arrayDice[i].displayDice(i+1); 
            }
            calcRoll();
            n = 1;
        }
        wait(0.1);
    }       
}

void FarkleGame::calcRoll() {
    pb1.mode(PullUp);
    pb3.mode(PullUp);
    rollScore = 0;
    for (int i = 0; i < 6; i++) {
        count[i] = 0;
    }
    for (int i = 0; i < numDie; i++) {
        if (values[i] == 1){count[0]++;}
        else if (values[i] == 2){count[1]++;}
        else if (values[i] == 3){count[2]++;}
        else if (values[i] == 4){count[3]++;}
        else if (values[i] == 5){count[4]++;}
        else{count[5]++;}  
    }
    if (count[0] == 1 and count[1] == 1 and count[2] == 1 and count[3] == 1 and count[4] == 1 and count[5] == 1) {rollScore += 1500;}
    else {
        for (int j = 0; j < 6; j++){
            if (j == 0) {rollScore += (count[j]/3)*1000 + (count[j]%3)*100;}
            else if (j == 1) {rollScore += (count[j]/3)*200;}
            else if (j == 2) {rollScore += (count[j]/3)*300;}
            else if (j == 3) {rollScore += (count[j]/3)*400;}
            else if (j == 4) {rollScore += (count[j]/3)*500 + (count[j]%3)*50;}
            else {rollScore += (count[j]/3)*600;}
        }
    }
    if (rollScore == 0) {
        totalScore = 0;
        myLCD.color(WHITE);
        myLCD.text_width(1);
        myLCD.text_height(1);
        myLCD.locate(0,12);
        myLCD.printf("FARKLE!");
        mySpeaker.PlayNote(300, 0.15, 0.05);
        wait(0.1);
        mySpeaker.PlayNote(300, 0.15, 0.05);
        while(1) {
            if(pb1 == false) {
                mySpeaker.PlayNote(600, 0.15, 0.05);
                displayScore();
            }
        }
    }else {
        totalScore += rollScore;
        myLCD.color(WHITE);
        myLCD.text_width(1);
        myLCD.text_height(1);
        myLCD.locate(0,12);
        myLCD.printf("Roll Score: %d\n", rollScore);
        myLCD.printf("Turn Score: %d\n", totalScore);
        while(1) {
            if (pb3 == false) {
                mySpeaker.PlayNote(800, 0.15, 0.05);
                takeAway();
            }
            else if (pb1 == false) {
                mySpeaker.PlayNote(600, 0.15, 0.05);
                displayScore();
            }
        }
    }
    
}

void FarkleGame::displayScore() {
    myLCD.cls();
    myLCD.text_width(2);
    myLCD.text_height(2);
    myLCD.locate(0,1);
    myLCD.printf("Your\nTurn\nScore\n-----\n %d\n", totalScore);
    numDie = 6;
    while(1) {
        if (pb1 == false) {
            mySpeaker.PlayNote(600, 0.15, 0.05);
            rollScore = 0;
            totalScore = 0;
            runFarkle();
        }
    }
}

void FarkleGame::takeAway() {
    sub = 0;
    if (count[0] == 1 and count[1] == 1 and count[2] == 1 and count[3] == 1 and count[4] == 1 and count[5] == 1) {sub = 0;}
    else {
        for (int j = 0; j < 6; j++){
            if (j == 0) {sub += (count[0]/3)*3 + (count[0]%3);}
            else if (j == 1) {sub += (count[1]/3)*3;}
            else if (j == 2) {sub += (count[2]/3)*3;}
            else if (j == 3) {sub += (count[3]/3)*3;}
            else if (j == 4) {sub += (count[4]/3)*3 + (count[4]%3);}
            else {sub += (count[5]/3)*3;}
        }
    }
    numDie -= sub;
    if (numDie == 0) {
        numDie = 6;
        runFarkle();
    }else {runFarkle();}
}