#include "mbed.h"
#include "WITB.h"

uLCD_4DGL myLCD(p9, p10, p11);
Speaker mySpeaker(p21);
PinDetect pb1(p19);
PinDetect pb2(p18);
PinDetect pb3(p17);
Serial pc(USBTX,USBRX);



#define ASTEROID_HEIGHT 12
#define ASTEROID_WIDTH 15
#define SPRITE_MAX 15
#define EARTH_WIDTH 10
#define EARTH_HEIGHT 10
#define EXPLOSION1_WIDTH 20
#define SCREEN_MAX 125
#define SCREEN_MIN 1
#define NUM_ASTEROIDS 4
#define Q 0x808000 //OLIVE 
#define I 0x008000 //GREEN 
#define S 0xC0C0C0 //SILVER 
#define C 0x17202A //UFO GLASS 
#define D 0x797D7F //DARK GREY 
#define L 0x00FF00 //LIME 
#define P 0xFF00FF //PINK 
#define R 0xF1C40F //YELLOW 
#define O 0xF39C12 //ORANGE 
#define G 0xAAB7B8 //GREY 
#define _ 0x000000 //BLACK 
#define X 0xFFFFFF //WHITE 
#define B 0x0000FF //BLUE 
#define r 0xFF0000 //RED

void clear(){
    myLCD.cls();   
}

int asteroid_sprite_1[ASTEROID_HEIGHT * ASTEROID_WIDTH] = {
_,_,_,_,X,X,X,X,X,X,X,X,_,_,_, 
_,_,_,X,_,_,_,_,_,_,_,_,X,_,_, 
_,_,X,_,_,_,_,_,_,_,_,_,X,_,_, 
_,X,_,_,_,_,_,_,_,_,_,_,X,_,_, 
X,X,X,X,_,_,_,_,_,_,_,_,_,X,_, 
_,_,_,X,_,_,_,_,_,_,_,_,_,X,_, 
_,_,X,_,_,_,_,_,_,_,_,_,_,X,_, 
_,X,_,_,_,_,_,X,_,_,_,_,_,X,_, 
X,_,_,_,_,_,X,X,_,_,_,_,X,_,_, 
_,X,_,_,_,X,_,X,_,_,_,_,X,_,_, 
_,_,X,_,X,_,_,X,_,_,_,X,_,_,_, 
_,_,_,X,_,_,_,X,X,X,X,_,_,_,_ 
};

int asteroid_sprite_2[ASTEROID_HEIGHT * ASTEROID_WIDTH] = {
_,_,_,_,X,X,X,_,_,_,X,X,_,_,_, 
_,_,_,X,_,_,_,X,_,X,_,_,X,_,_, 
_,_,X,_,_,_,_,_,X,_,_,_,_,X,_, 
_,X,_,_,_,_,_,_,_,_,_,_,X,_,_, 
X,_,_,_,_,_,_,_,_,_,_,X,_,_,_, 
X,_,_,_,_,_,_,_,_,_,_,_,X,_,_, 
X,_,_,_,_,_,_,_,_,_,_,_,X,_,_, 
X,_,_,_,_,_,_,_,_,_,_,_,_,X,_, 
X,_,_,_,_,_,_,_,_,_,_,_,X,_,_, 
_,X,_,_,_,_,_,_,_,_,_,_,X,_,_, 
_,_,X,_,_,_,_,_,_,_,_,X,_,_,_, 
_,_,_,X,X,X,X,X,X,X,X,_,_,_,_ 
};

int asteroid_sprite_3[ASTEROID_HEIGHT * ASTEROID_WIDTH] = {
_,_,_,_,X,X,_,_,_,_,X,X,_,_,_, 
_,_,_,X,_,_,X,X,_,X,_,_,X,_,_, 
_,_,X,_,_,_,_,_,X,_,_,_,X,_,_, 
_,X,_,_,_,_,_,_,_,_,_,_,X,_,_, 
X,X,_,_,_,_,_,_,_,_,_,_,_,X,_, 
_,_,X,_,_,_,_,_,_,_,_,_,_,X,_, 
_,_,X,_,_,_,_,_,_,_,_,_,_,X,_, 
_,X,_,_,_,_,_,_,_,_,_,_,_,X,_, 
X,_,_,_,_,_,_,_,_,_,_,_,X,_,_, 
_,X,_,_,_,X,X,X,_,_,_,_,X,_,_, 
_,_,X,_,X,_,_,_,X,_,_,X,_,_,_, 
_,_,_,X,_,_,_,_,_,X,X,_,_,_,_ 
};

int asteroid_sprite_4[ASTEROID_HEIGHT * ASTEROID_WIDTH] = {
_,_,_,_,X,X,X,X,X,X,X,X,_,_,_, 
_,_,_,X,_,_,_,_,_,_,_,_,X,_,_, 
_,_,X,_,_,_,_,_,_,_,_,_,X,_,_, 
_,X,_,_,_,_,_,_,_,_,_,_,X,_,_, 
X,X,X,X,_,_,_,_,_,_,_,_,X,_,_, 
_,_,_,X,_,_,_,_,_,_,_,X,_,_,_, 
_,_,X,_,_,_,_,_,_,_,X,_,_,_,_, 
_,X,_,_,_,_,_,_,_,_,_,X,_,_,_, 
X,_,_,_,_,_,_,_,_,_,_,_,X,_,_, 
_,X,_,_,_,_,X,X,_,_,_,_,X,_,_, 
_,_,X,_,X,X,_,X,_,_,_,X,_,_,_, 
_,_,_,X,_,_,_,_,X,X,X,_,_,_,_ 
};

int spaceship_earth1[EARTH_WIDTH *EARTH_HEIGHT] = {
_,_,S,S,S,S,S,S,_,_, 
_,S,I,I,I,I,I,I,S,_, 
S,I,I,I,I,I,I,I,I,S, 
S,I,I,I,I,I,I,I,I,S, 
S,I,I,I,I,I,I,I,I,S, 
S,I,I,I,I,I,I,I,I,S, 
S,I,I,I,I,I,I,I,I,S, 
S,I,I,I,I,I,I,I,I,S, 
S,I,I,I,I,I,I,I,S,_, 
_,S,S,S,S,S,S,S,_,_, 
};

int explosion[EARTH_WIDTH *EARTH_HEIGHT] = {
r,_,_,_,_,_,_,_,_,r, 
_,r,O,_,_,_,_,O,r,_, 
_,O,r,O,O,O,O,r,O,_, 
_,_,O,r,r,r,r,O,_,_, 
_,_,O,r,R,R,r,O,_,_, 
_,_,O,r,R,R,r,O,_,_, 
_,_,O,r,r,r,r,O,_,_, 
_,O,r,O,O,O,O,r,O,_, 
_,r,O,_,_,_,_,O,r,_, 
r,_,_,_,_,_,_,_,_,r, 
};

void ScreenObject::setXPos(int x) {xPos = x;}
void ScreenObject::setYPos(int y) {yPos = y;}
int ScreenObject::getXPos() {return xPos;}
int ScreenObject::getYPos() {return yPos;}
void ScreenObject::setBaud() {myLCD.baudrate(600000);}

bool overlap(ScreenObject & objectA, ScreenObject & objectB)
{
    if ((objectA.getXPos() < (objectB.getXPos() + 10)) and (objectA.getXPos() > objectB.getXPos()))
    {
        if ((objectA.getYPos() > objectB.getYPos()) and (objectA.getYPos() < (objectB.getYPos() + 10))){
            return true;
        }else if (((objectA.getYPos()+10) > objectB.getYPos()) and ((objectA.getYPos()+10) < (objectB.getYPos() + 10))){
            return true;
        }else{
            return false;   
        }
    }else if (((objectA.getXPos()+ 10) < (objectB.getXPos() + 10)) and ((objectA.getXPos() + 10) > objectB.getXPos())){
        if ((objectA.getYPos() > objectB.getYPos()) and (objectA.getYPos() < (objectB.getYPos() + 10))){
            return true;
        }else if (((objectA.getYPos()+10) > objectB.getYPos()) and ((objectA.getYPos()+10) < (objectB.getYPos() + 10))){
            return true;
        }else{
            return false;   
        }
    }else{
        return false;   
    }
}

void loseGame(ScreenObject & A)
{
    clear();
    myLCD.BLIT(A.getXPos(), A.getYPos(), 10, 10, explosion);
    mySpeaker.PlayNote(600, 0.15, 0.05);
    mySpeaker.PlayNote(700, 0.15, 0.05);
    mySpeaker.PlayNote(800, 0.15, 0.05);
    mySpeaker.PlayNote(600, 0.15, 0.05);
    wait(3);
    clear();
    myLCD.color(WHITE);
    myLCD.text_width(2);
    myLCD.text_height(2);
    myLCD.locate(0,12);
    myLCD.printf("LOSER!");
    while(1){
        myLCD.printf("LOSER!");
    }
}


void EarthSS::setdx(int x) {dx = x;}
void EarthSS::setdy(int y) {dy = y;}
int EarthSS::getdx(){return dx;}
int EarthSS::getdy(){return dy;}

void EarthSS::draw()
{
   this->setXPos(64);
   this->setYPos(64);
   myLCD.BLIT(this->getXPos(), this->getYPos(), 10, 10, spaceship_earth1);
}

void EarthSS::update()
{
    this->setXPos(this->getXPos() - this->getdx());
    myLCD.BLIT(this->getXPos(), this->getYPos(), 10, 10, spaceship_earth1);
}

void AbstractAsteroid::setdx(int x) {dx = x;}
void AbstractAsteroid::setdy(int y) {dy = y;}
int AbstractAsteroid::getdx() {return dx;}
int AbstractAsteroid::getdy() {return dy;}



void ConcreteAsteroid1::draw()
{
    this->setXPos(rand() % 110);
    this->setYPos(10);
}

void ConcreteAsteroid1::update()
{
    this->setYPos(this->getYPos() + this->getdx());
    this->setXPos(this->getXPos() + this->getdy());
    if ( this->getXPos() < 0)
    {
        this->setXPos(110);   
    }
    if ( this->getXPos() > 110 )
    {
        this->setXPos(0);   
    }
    myLCD.BLIT(this->getXPos(), this->getYPos(), 15, 12, asteroid_sprite_1);
}

void ConcreteAsteroid2::draw()
{
    this->setXPos(rand() % 110);
    this->setYPos(0);
}

void ConcreteAsteroid2::update()
{
    this->setYPos(this->getYPos() + this->getdx());
    this->setXPos(this->getXPos() + this->getdy());
    if ( this->getXPos() < 0)
    {
        this->setXPos(110);   
    }
    if ( this->getXPos() > 110 )
    {
        this->setXPos(0);   
    }
    myLCD.BLIT(this->getXPos(), this->getYPos(), 15, 12, asteroid_sprite_2);
}

void ConcreteAsteroid3::draw()
{
    this->setXPos(rand() % 110);
    this->setYPos(0);
}

void ConcreteAsteroid3::update()
{
    this->setYPos(this->getYPos() + this->getdx());
    this->setXPos(this->getXPos() + this->getdy());
    if ( this->getXPos() < 0)
    {
        this->setXPos(110);   
    }
    if ( this->getXPos() > 110 )
    {
        this->setXPos(0);   
    }
    myLCD.BLIT(this->getXPos(), this->getYPos(), 15, 12, asteroid_sprite_3);
}

void ConcreteAsteroid4::draw()
{
    this->setXPos(rand() % 110);
    this->setYPos(0);
}

void ConcreteAsteroid4::update()
{
    this->setYPos(this->getYPos() + this->getdx());
    this->setXPos(this->getXPos() + this->getdy());
    if ( this->getXPos() < 0)
    {
        this->setXPos(110);   
    }
    if ( this->getXPos() > 110 )
    {
        this->setXPos(0);   
    }
    myLCD.BLIT(this->getXPos(), this->getYPos(), 15, 12, asteroid_sprite_4);
}


void GameTimer::setY(int Y) {this->y = Y;}
int GameTimer::getX(){return x;}
int GameTimer::getY(){return y;}
void GameTimer::setdx(int x) {this->dx = x;}
void GameTimer::setdy(int y) {this->dy = y;}
int GameTimer::getdx() {return dx;}
int GameTimer::getdy() {return dy;}

void GameTimer::draw()
{
    StartTime = time(0); 
    ElapsedTime = time(0) - StartTime;  
    this->setX(128);
    this->setY(10);
    myLCD.filled_rectangle(this->getXPos(), this->getYPos(), this->getX(), this->getY(), B);   
}

void GameTimer::update()
{
    float t = 4.26;
    ElapsedTime = time(0) - StartTime;
    this->setX(128 - floor(t * ElapsedTime));
    myLCD.filled_rectangle(this->getXPos(), this->getYPos(), this->getX(), this->getY(), B);  
    if (this->getX() < 3)
    {
        winGame();
    }     
}

void winGame(){
    clear();
    myLCD.color(WHITE);
    myLCD.text_width(2);
    myLCD.text_height(2);
    myLCD.locate(0,12);
    myLCD.printf("WINNER!");
    while(1)
    {
        myLCD.printf("WINNER!");
    } 
}

void endGame(){
    while(1){}   
}