#include "mbed.h"
#include "WITB.h"

int main() {
    srand(time(0));
    EarthSS A;
    A.setBaud();
    A.draw();
    GameTimer B;
    B.draw();
    
    ScreenObject * ActiveAsteroids[] = {new ConcreteAsteroid1(), new ConcreteAsteroid2(), new ConcreteAsteroid3(), new ConcreteAsteroid4()};
    for (int i = 0; i < 4; i++)
    {
        (*ActiveAsteroids[i]).setYPos(10);
        (*ActiveAsteroids[i]).setXPos(rand() % 110);
        (*ActiveAsteroids[i]).setdx(rand()%5 + 3);
        (*ActiveAsteroids[i]).setdy(rand()%10 - 5);
        (*ActiveAsteroids[i]).draw();  
    }
    
    double x = 0, y = 0, z = 0;
 
    MMA8452 acc(p28, p27, 40000);  //instantiate an acc object! 
    
    //set parameters -- use these and don't change
    acc.setBitDepth(MMA8452::BIT_DEPTH_12);
    acc.setDynamicRange(MMA8452::DYNAMIC_RANGE_4G);
    acc.setDataRate(MMA8452::RATE_100);
    
    
    
    while(1)
    {
        wait(0.1);
        clear();
        acc.readXYZGravity(&x,&y,&z);
        int dx = floor(12 * x + 1);
        A.setdx(dx);
        A.update();
        B.update();
        
        for (int i = 0; i < 4; i++)
        {
            if ((*ActiveAsteroids[i]).getYPos() > 110)
            {
                (*ActiveAsteroids[i]).setYPos(10);
                (*ActiveAsteroids[i]).setXPos(rand() % 110);
                (*ActiveAsteroids[i]).setdx(rand()%5 + 3);
                (*ActiveAsteroids[i]).setdy(rand()%10 - 5);   
            }
            (*ActiveAsteroids[i]).update();
        }
        for (int i = 0; i < 4; i++)
        {
            if (overlap(A, (*ActiveAsteroids[i])))
            {
                loseGame(A);
                break;
            }  
        }
    }
}
