#include "mbed.h"
#include "uLCD_4DGL.h"
#include "MMA8452.h"
#include "Speaker.h"
#include "PinDetect.h"
#include <cmath>
#include <ctime>

#ifndef WITB_H
#define WITB_H

void clear();
void endGame();


class ScreenObject{
    private:
        int xPos;
        int yPos;
        
    public:
        ScreenObject()
         : xPos(0), yPos(0) {}

        void setXPos(int x);
        void setYPos(int y);
        int getXPos();
        int getYPos();
        virtual void setdx(int x) = 0;
        virtual void setdy(int y) = 0;
        virtual int getdx() = 0;
        virtual int getdy() = 0;
        
        void setBaud();
         
        virtual void draw() = 0;
        virtual void update() = 0;
        
};

class GameTimer : public ScreenObject{
    private:
        int x;
        int y;
        int dx;
        int dy;
        time_t StartTime;
        time_t ElapsedTime;
        
    public:
        GameTimer()
         : x(0), y(0) {}
         
        void setX(int X){x = X;}
        void setY(int Y);
        int getX();
        int getY();
        
        void starttimer();
        
        virtual void setdx(int x);
        virtual void setdy(int y);
        virtual int getdx();
        virtual int getdy();
        virtual void draw();
        virtual void update();   
};

class AbstractAsteroid : public ScreenObject{
    private:
        int dx;
        int dy;
        
    public:
        AbstractAsteroid()
         : dx(0), dy(0) {}
         
        virtual void setdx(int x);
        virtual void setdy(int y);
        virtual int getdx();
        virtual int getdy();
};

class EarthSS : public ScreenObject{
    private:
        int dx;
        int dy;

    public:
        EarthSS()
         : dx(0), dy(0) {}
    
        virtual void setdx(int x);
        virtual void setdy(int y);
        virtual int getdx();
        virtual int getdy();
    
        virtual void draw();
        virtual void update();
};

class ConcreteAsteroid1 : public AbstractAsteroid{
    private:
        
    public:
        ConcreteAsteroid1() {}
        virtual void draw();
        virtual void update();
    
};

class ConcreteAsteroid2 : public AbstractAsteroid{
    private:
        
    public:
        ConcreteAsteroid2() {}
        virtual void draw();
        virtual void update();
};

class ConcreteAsteroid3 : public AbstractAsteroid{
    private:
        
    public:
        ConcreteAsteroid3() {}
        virtual void draw();
        virtual void update();
};

class ConcreteAsteroid4 : public AbstractAsteroid{
    private:
    
    public:
        ConcreteAsteroid4() {}
        virtual void draw();
        virtual void update();
    
};

bool overlap(ScreenObject & objectA, ScreenObject & objectB);

void loseGame(ScreenObject & A);
void winGame();

#endif