#include "motor.h"
#include "mbed.h"
#define control_speed 1


void MOTOR::stop() {//stop the motors
     dir1 = 0;
     dir2 = 0;
     dir3 = 0;
     dir4 = 0;
     pwm1.write(0);
     pwm2.write(0);
}

void MOTOR::balance(float speed) {//for balancing the robot
    stop();//stop the motor
    if (speed<0)//if speed is - go backward  
    {
     dir1 = 1;
     dir2 = 0;
     dir3 = 0;
     dir4 = 1;
     float temp = abs(speed);//use PID output to detrmine the speed
     pwm1.write(temp);
     pwm2.write(temp);
     }
    else if (speed>0)//if speed is + go forward
    {
     dir1 = 0;
     dir2 = 1;
     dir3 = 1;
     dir4 = 0;
     float temp = abs(speed);
     pwm1.write(temp);
     pwm2.write(temp);
     } 
}

void MOTOR::forward() {//go forward 
     stop(); 
     dir1 = 0;
     dir2 = 1;
     dir3 = 1;
     dir4 = 0;
     pwm1.write(control_speed);
     pwm2.write(control_speed);
}
     
void MOTOR::backward() {//go backward  
     stop(); 
     dir1 = 1;
     dir2 = 0;
     dir3 = 0;
     dir4 = 1;
     pwm1.write(control_speed);
     pwm2.write(control_speed);
}

void MOTOR::left() {//turn left    
     dir1 = 1;
     dir2 = 0;
     dir3 = 1;
     dir4 = 0;
     pwm1.write(control_speed);
     pwm2.write(control_speed);
}

void MOTOR::right() {//turn right   
     dir1 = 0;
     dir2 = 1;
     dir3 = 0;
     dir4 = 1;
     pwm1.write(control_speed);
     pwm2.write(control_speed);
}


    

