#ifndef MPU6050_H
#define MPU6050_H

#include "mbed.h"


#define slaveAddress 0x68<<1
extern Serial pc;
extern I2C i2c;

class MPU6050 
{
    protected:
    public: 
    void writeByte(char pointer, char bit);//write byte to register
    char readByte(char pointer);//read 1 byte from register
    void readBytes(char pointer, char *bytes, char length);//read more than 1 byte from register
    void whoAmI();//check the whoAmI register
    void init();//initialize the mpu
    void gyro(float *val);//read gyro value (in degree/sec)
    void acc(float *val);//read acc value (in g)
    void sleep(bool state);
    void filtered(float old_p, float *val, float time, float offset, float sp);//complimentary filter
};

#endif