 #include "mbed.h"
 #include "SDBlockDevice.h"
 #include "FATFileSystem.h"
 //#include "sample_hardware.hpp"
 #include "mbed_events.h"
 

SDBlockDevice sd(D11, D12, D13, D10); 
EventQueue eq;
FILE* fp;
bool ejected = false; 
void takeSample()
{
    if (ejected == true) {
        return;    
    }
    float temp     = sensor.getTemperature();
    float pressure = sensor.getPressure();
    
    fprintf(fp, "%f,%f\n", temp, pressure);
    
    redLED = 1;
    Thread::wait(100);
    redLED = 0;
    
    if ((SW1 == 1) && (SW2 == 1)) {
        //Close File
        fclose(fp);
        
        sd.deinit();
        
        puts("You can now remove the SD Card\n");
        yellowLED = 1;
        
        ejected = true;
    }
}
 
 int main()
{
    //POWER ON SELF TEST
    post();
    
    printf("Initialise\n");
    //FileSystemLike(*sd);

    // call the SDBlockDevice instance initialisation method.
    if ( sd.init() != 0) {
        printf("Init failed \n");
        errorCode(FATAL);
    }    
    
    //Create a filing system for SD Card
    FATFileSystem fs("sd", &sd);
    
    // **************
    // Open to APPEND
    // **************
    fp = fopen("/sd/test.txt","a");
    
    //Check file handle (stream)
    if (fp == NULL) {
        error("Could not open file for write\n");
        errorCode(FATAL);
    }
    
    //Set up tasks on the main thread
    queue.call_every(5000, takeSample);
    
    //Main queue event loop
    queue.dispatch();

}