/*
File: DanceDanceFullGame_SECONDMBED.main.cpp
Author: Akshay Nagendra, Weiyu Liu
Description: File responsible for operating the second mbed, in charge of listening to the main mbed for a ready signal and then playing the music for the game
*/
#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"

//setup variables and objects for music playing
AnalogOut DACout(p18); //music played using analog out
wave_player waver(&DACout);
SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sck, cs
DigitalIn gameStarted(p22); //signal from main mbed (asserted when a song has been selected)

Serial pc(USBTX, USBRX);
AnalogIn drum1(p15);

DigitalOut led1(LED1);
DigitalOut led2(LED2);

float reading;

void playSound(char * wav);

int main(){
    wait(5.5);
    while(!gameStarted){
           led1 = 1;  
             //wait until the main mbed send the ready signal for playing a song (players are still readying up and selecting music)   
    } 
    led1 = 0;
    led2 = 1;
    wait(9.00); //a delay so that the arrow lines up with the first note of the song
    playSound("/sd/rock.wav");
}

void playSound(char * wav)
    //helper function to play the music 
{
    // open wav file
    FILE *wave_file;
    wave_file=fopen(wav,"r");
 
    // play wav file
    waver.play(wave_file);

    // close wav file
    fclose(wave_file);
}