#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"

// Define pins
SDFileSystem sd(p5, p6, p7, p8, "sd"); 
AnalogOut DACout(p18); 
wave_player wave(&DACout);
DigitalIn gameStarted(p22);

// Serial pc(USBTX, USBRX);

DigitalOut led1(LED1);
DigitalOut led2(LED2);

float reading;

void playSound(char * wav);

int main(){
    // Wait for first mbed to pull down the pin
    wait(5.5);
    
    // Wait until the player hits the start button
    while(!gameStarted){
        led1 = 1;  
    } 
    
    // LED2 indicates the that mbed will start playing the music
    led1 = 0;
    led2 = 1;
    wait(8.00); // Delay to line u first note with the song
    playSound("/sd/obladi.wav");
}

// Function that plays the music
void playSound(char * wav) {
    // open wav file
    FILE *wave_file;
    wave_file=fopen(wav,"r");
 
    // play wav file
    wave.play(wave_file);

    // close wav file
    fclose(wave_file);
}