#include "mbed.h"
#include "TFT_4DGL.h"
#include "note.h"
#include "song.h"
#include <vector>

// Define all the ports
// Serial pc(USBTX, USBRX);
TFT_4DGL screen(p9,p10,p11); // serial tx, serial rx, reset pin;
AnalogIn drum1(p18);
AnalogIn drum2(p19);
AnalogIn drum3(p20);
DigitalOut musicOn(p22);
DigitalIn button(p21);

// Define objects
Ticker t1;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

// Define and initiate global variables
std::vector<Note> noteArr; 
int beatNumber = 0;
char buffer[2];
int skipped = 0;
int temp;
int score = 0;
Song s = Song(1);

// Define the drum variables
volatile int r1;
volatile int r2;
volatile int r3;
volatile int r11;
volatile int r22;
volatile int r33;

// Function that draws the initial game frame
void initiateScreen() {
    // Initiate the screen and the background
    screen.baudrate(3000000);
    screen.display_control(0x0c, 0x01);
    screen.background_color(0x000000);
    
    // Draw the frame
    screen.rectangle(192, 120, 447, 450, 0xD38A41);
    screen.line(256, 120, 192, 450, 0x96411F);
    screen.line(296, 120, 277, 450, 0x96411F);
    screen.line(332, 120, 362, 450, 0x96411F);
    screen.line(372, 120, 447, 450, 0x96411F);
    screen.triangle(192, 120, 192, 450, 256, 120, 0x000000);
    screen.triangle(372, 120, 447, 450, 447, 120, 0x000000);
    screen.rectangle(447, 120, 450, 450, 0x000000);
    
    screen.rectangle(256, 100, 296, 120, 0xFF0000);
    screen.rectangle(296, 100, 332, 120, 0x00FF00);
    screen.rectangle(332, 100, 372, 120, 0x0000FF);
    
    // Define the points
    screen.graphic_string("POINTS:", 30, 100, FONT_8X8, WHITE, 2, 2);
    
    screen.graphic_string("OB-LA-DI", 430, 100, FONT_8X8, WHITE, 2, 2);    
}

// The function that the ticker will be running, it checks if the piezo sensors
// sense a hit two cycles (0.002 sec) in a row. Checking for two consecutive
// high values discards the noise in the piezo sensors.
void checkDrums() {
    if (drum1 == 1) {
        if (r1 == 1) {
            r11 = 1;
        } else {
            r1 = 1;
        };   
    } else if (drum2 == 1) {
        if (r2 == 1) {
            r22 = 1;
        } else {
            r2 = 1;
        };   
    } else if (drum3 == 1) {
        if (r3 == 1) {
            r33 = 1;
        } else {
            r3 = 1;
        }; 
    }
}

// Main methods that runs the main loop that checks the drums hits and draws the
// next set of notes on the board.
int main() {
    button.mode(PullDown);    
    screen.text_string("DRUM HERO 1.0", 15, 8, FONT_8X8, WHITE);  
    screen.text_string("PRESS THE BUTTON", 14, 16, FONT_8X8, WHITE);
    screen.text_string("TO START", 18, 19, FONT_8X8, WHITE);    
    
    musicOn = 0;
    while(!musicOn) {
        if(button) {
            musicOn = 1;
        }    
    }  
      
    // Initiate the screen and the main graphics
    initiateScreen();   
     
    t1.attach(&checkDrums, 0.001);
    
    while (true) {        
        // Check if the song is ended
        if (beatNumber < s.length) {
            // Check if the drum ticker sensed any hits
            if (r11) {
                // Draw hit drums for user feedback
                screen.rectangle(192,450,277,470,0xFF0000);
                led1 = 1;
                // Notes move down 5 times, check the note array in the index of 
                // 5 notes before and see if it matches with the right drum
                if (s.notes[beatNumber - 5] == 1) {
                    score++;
                }
                r1 = 0;
                r11 = 0;
            } else if (r22) {
                screen.rectangle(277,450,362,470,0x00FF00);
                led2 = 1;
                if (s.notes[beatNumber - 5] == 2) {
                    score++;
                }
                r2 = 0;
                r22 = 0;
            } else if (r33) {
                screen.rectangle(362,450,447,470,0x0000FF);
                led3 = 1;
                if (s.notes[beatNumber - 5] == 3) {
                    score++;
                }
                r3 = 0;
                r33 = 0;
            } else {
                screen.rectangle(192,450,447,470,0x000000);
                led1 = 0;
                led2 = 0;
                led3 = 0;
            }
            
            // Read the next beat (0,1,2,3)
            temp = s.notes[beatNumber++];
            // Check if there's a beat/note (not 0)
            if (temp) {
                // If beat/note exists, create the object for it and push
                // it to the array of current notes on the screen
                Note n1 = Note(temp);
                noteArr.push_back(n1);
            }   
                         
            for (int i = skipped; i < noteArr.size(); i++) {
                if (noteArr[i].consumed) {
                    skipped += 1;
                } else {
                    noteArr[i].drawNote();
                }
            }
        } else {
             // Game over screen
             screen.rectangle(0,0,640,480,0x000000);
             screen.graphic_string("GAME OVER", 240, 170, FONT_8X8, WHITE, 2, 2);
             screen.graphic_string("YOUR SCORE IS:", 210, 230, FONT_8X8, WHITE, 2, 2);
             screen.graphic_string(buffer, 290, 260, FONT_8X8, WHITE, 2, 2);
             wait(30);               
        }
        // Update the score after each iteration
        sprintf(buffer,"%d",score);
        screen.graphic_string(buffer, 30, 120, FONT_8X8, WHITE, 2, 2);
    }
}