#ifndef SONG_H__
#define SONG_H__

#include <vector>

class Song {
    public:
        // ID of the song to be played
        int songId;
        
        // The notes that will be coming, type's of notes(1,2,3) that determine
        // if a beat needs to be hit or not, 0's mean no hit, (4 means end of the
        // song)
        std::vector<int> notes;
        
        // The length of the array
        int length;
        
        // BPM value, or the time value between two notes
        float timing;
        
        // Construct a song with a certain ID
        Song(int id);
};
#endif
