#ifndef NOTE_H__
#define NOTE_H__

#define MIN_Y 130
#define MAX_Y 430

class Note {
    public:
    
        // Type of the note (1,2,3) - (left, center, right)
        int type;
        
        // Position accros the fret
        float x,y;
        
        // Sizes of the displayed note
        float w,h;
        
        // Speed of the the note
        int speed;
        
        // Color of the note
        int color;
        
        // Flag showing if the note is already consumed
        int consumed;
    
        // Constructor of the note, no args
        Note();
        
        // Constructor of the note, initiate with type
        Note(int t);
        
        // Destructor for the note
        ~Note();
        
        // Update the position of the note based on its speed
        void updatePosition();
        
        // Draw the note with its current stats on the screen
        void drawNote();
  
};
#endif