/**
 * @file    LightResource.h
 * @brief   mbed CoAP Endpoint Light resource supporting CoAP GET and PUT
 * @author  Doug Anson, Michael Koster
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __TOUCH_RESOURCE_H__
#define __TOUCH_RESOURCE_H__

#define SIZE_STR_REP 2
#define SIZE_STR_TIMESTAMP 10
#define SIZE_MAX_ARR 50
#define SIZE_MAX_RESULTS 700

#include <stdio.h>
#include <time.h>

// Base class
#include "DynamicResource.h"
#include "mbed.h"
#include "MMA7660.h"


DigitalIn button(D2);
MMA7660 accelemeter;

int reps[SIZE_MAX_ARR];
int times[SIZE_MAX_ARR];
int idx = 0;

char result[SIZE_MAX_RESULTS];

void touch_thread(void const *args)
{
    float ax, ay, az;
    accelemeter.init();
    bool up = false;
    int rep = 0;
    int i = 0;
    
    for (i = 0; i < 50; i++)
        reps[i] = -1;
    while(1) {
        if (!button) {
            printf("touch detected\n\r");
            LED_set_color("0000FF00");
            while(!button) {
                accelemeter.getAcceleration(&ax,&ay,&az);
                printf("Accleration of X=%2.2fg, Y=%2.2fg, Z=%2.2fg\n\r",ax,ay,az);
                if (ay < 0.7f) {
                    up = true;
                }
                if (ay > 0.9f) {
                    if (up)
                        rep++;
                    up = false;
                }
            }

            LED_set_color("00000000");
            printf("Reps = %d\n\r", rep);
            reps[idx] = rep;
            times[idx++] = (int)time(NULL);
            rep = 0;
        }
    }
}

    /** LightResource class
     */
    class TouchResource : public DynamicResource
    {

    public:
        /**
        Default constructor
        @param logger input logger instance for this resource
        @param name input the Light resource name
        @param observable input the resource is Observable (default: FALSE)
        */
        TouchResource(const Logger *logger,const char *name,const bool observable = false) : DynamicResource(logger,name,"Touch",SN_GRS_GET_ALLOWED,observable) {
        }

        /**
        Get the value of the LED
        @returns string containing the last setting
        */
        virtual string get() {
            int i = 0;
            memset(result, 0, SIZE_MAX_RESULTS);
            
            for (i = 0; i < idx; i++) {
                sprintf(result+(i*(SIZE_STR_REP + SIZE_STR_TIMESTAMP + 2)), "%2d,", reps[idx]);
                sprintf(result+(SIZE_STR_REP+1)+(i*(SIZE_STR_REP + SIZE_STR_TIMESTAMP + 2)), "%10d,", times[idx]);
            }
            
            for (i = 0; i < 50; i++)
                reps[i] = -1;
            idx = 0;
            printf("results: %s\n", result);
            
            return(result);
        }
    };

#endif // __TOUCH_RESOURCE_H__

