#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "BH1750.h"
#include "Peripherals.h"

#define ECHO_SERVER_PORT   23

BH1750 light(I2C_SDA, I2C_SCL); // Senzor osvětlení
Humid humidity;                 // Senzor vlhkosti
Temp temperature;               // Snímač teploty
Vent ventilation;               // Otevírání ventilace
Fan conditioning;               // Ovládání aktivního větrání
Heat heating;                   // Ovládání topení
Water irrigation;               // Spouštění zavlažování
Light illumination;             // Ovládání světel

enum STAT                       // Proměnná pro uložení stavu celého systému
{
    READY = 1, SETTINGS, MANUAL, ERROR
}sklenikstav;

char line1[50], line2[50], line3[50]; // Řetězce pro vypsání stavu skleníku               


int evaluate(char *str)
{
    switch(sklenikstav)
    {
        case READY:
            if (strcmp(str, "help") == 0)
            {
                return 1;
            }
            else if (strcmp(str, "stav") == 0)
            {
                return 2;
            }
            else if (strcmp(str, "set") == 0)
            {
                return 3;
            }
            else if (strcmp(str, "man") == 0)
            {
                return 4;
            }
            else if ((strcmp(str, "quit") == 0) || (strcmp(str, "exit") == 0))
            {
                return 5;
            }
            else
                return 0;
        case SETTINGS:
            return 0;
        case MANUAL:
            if (strcmp(str, "zalij") == 0)
            {
                return 1;
            }
            else if (strcmp(str, "nezalevej") == 0)
            {
                return 2;
            }
            else if (strcmp(str, "ventot") == 0)
            {
                return 3;
            }
            else if (strcmp(str, "ventzav") == 0)
            {
                return 4;
            }
            else if (strcmp(str, "vetranizap") == 0)
            {
                return 5;
            }
            else if (strcmp(str, "vetranivyp") == 0)
            {
                return 6;
            }
            else if (strcmp(str, "topzap") == 0)
            {
                return 7;
            }
            else if (strcmp(str, "topvyp") == 0)
            {
                return 8;
            }
            else if (strcmp(str, "svetlozap") == 0)
            {
                return 9;
            }
            else if (strcmp(str, "svetlovyp") == 0)
            {
                return 10;
            }
            else if (strcmp(str, "zpet") == 0)
            {
                return 11;
            }
            else if ((strcmp(str, "quit") == 0) || (strcmp(str, "exit") == 0))
            {
                return 12;
            }
            else
                return 0;
        default:
            return 0;
    } 
}

void state(void)
{
    sprintf(line1, "Teplota:\t%.1f \tdegC\r\n", temperature.readTemperature());
    sprintf(line2, "Vlhkost:\t%d \t%%\r\n", humidity.readHumidity());
    sprintf(line3, "Osvetleni:\t%d \tlx\r\n", light.singleMeas());
}

void watering_thread(void)
{
    while(true)
    {
        uint8_t hum = humidity.readHumidity();
        float avghum = 0;
        if(hum < humidity.getLimit())
        {
            for(int i=0; i<6; i++)
            {
                avghum += humidity.readHumidity();
            }
            
            avghum /= 6;
            
            if(avghum < humidity.getLimit())
            {
                irrigation.Start();
                Thread::wait(180000);
                irrigation.Stop();
            }
            avghum = 0;
        }
        Thread::wait(900000);
    }
}

void venting_thread()
{
    while(true)
    {
        uint8_t temp = temperature.readTemperature();
        float avgtemp = 0;
        
        if(temp > temperature.getVentLimit())
        {
            for(int i=0; i<6; i++)
            {
                avgtemp += temperature.readTemperature();
            }
            
            avgtemp /= 6;
            
            if(avgtemp > temperature.getVentLimit())
            {
                ventilation.open();
                conditioning.Start();
                heating.Stop();
            }
            avgtemp = 0;
        }
        
        else if(temp > temperature.getHighLimit())
        {
            for(int i=0; i<6; i++)
            {
                avgtemp += temperature.readTemperature();
            }
            
            avgtemp /= 6;
            
            if(avgtemp > temperature.getHighLimit())
            {
                ventilation.open();
                conditioning.Stop();
                heating.Stop();
            }
            avgtemp = 0;
        }
        
        else if(temp < temperature.getLowLimit())
        {
            for(int i=0; i<6; i++)
            {
                avgtemp += temperature.readTemperature();
            }
            
            avgtemp /= 6;
            
            if(avgtemp < temperature.getLowLimit())
            {
                ventilation.close();
                conditioning.Stop();
                heating.Start();
            }
            avgtemp = 0;
        }
        
        else
        {
            ventilation.close();
            conditioning.Stop();
            heating.Stop();
        }
        
        Thread::wait(100000);
    }
}

void lighting_thread()
{
    uint16_t lx[6];
    for(int i=0; i<6; i++)
    {
        lx[i] = light.singleMeas();
    }
    
    while(true)
    {
        uint16_t avglx = 0;
        
        for(int i=0; i<5; i++)
        {
            lx[i] = lx[i+1];
        }
        lx[5] = light.singleMeas();
        
        for(int i=0; i<6; i++)
        {
            avglx += lx[i];
        }
        avglx /= 6;
        
        if(avglx<light.getLimit())
        {
            illumination.Start();
        }
        
        else
        {
            illumination.Stop();
        }
        
        Thread::wait(300000);
    }
}

int main () 
{
    sklenikstav = READY;
    //Thread thread1(watering_thread);
    /*Thread thread2(venting_thread);
    Thread thread3(lighting_thread);*/
    //thread.start(watering_thread);
    //thread2.start(venting_thread);
    //thread3.start(lighting_thread);
    
    //Thread thread1(watering_thread, NULL, osPriorityNormal, DEFAULT_STACK_SIZE, NULL);
    
    EthernetInterface eth;
    char mac[6];
    mbed_mac_address(mac);
    printf("\r\n\r\n");
    printf("FRDM-K64F mbed ethernet...\r\n");
    printf("MAC is %02x:%02x:%02x:%02x:%02x:%02x\r\n", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);

    eth.init(); // Použití DHCP (v routeru nastavena pevná adresa pro MAC adresu zařízení)
    if (eth.connect()) return -1;
    printf("IP Address is %s\r\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    
    char commandwait[] = "\nZadejte prikaz:\t";
    
    while (true) {
        printf("\nWait for new connection...\r\n");
        TCPSocketConnection client;
        server.accept(client);
        //client.set_blocking(false, 1500); // Povolení timeoutu po 1,5s
        
        printf("Connection from: %s\r\n", client.get_address());
        
        char welcomemsg[] = "Projekt automatizovaneho skleniku\r\nVytvoril: Josef Krivsky, Leden 2018\r\nPro seznam validnich prikazu pouzijte prikaz 'help'\r\n";
        client.send_all(welcomemsg, sizeof(welcomemsg));
        client.send_all(commandwait, sizeof(commandwait));
        
        while(true)
        {
            char message[256];
            char buffer;
            int number = 0;
            while (true) 
            {
                int n = client.receive(&buffer, 1);
                if ((n <= 0) || (number >= sizeof(message)))
                    break;
                else if (buffer == 0x0A)
                    number = number;
                else if (buffer == 0x0D)
                {
                    message[number] = '\0';
                    break;
                }
                else if ((buffer < 32) || (buffer > 127))
                    continue;
                else
                {
                    message[number] = buffer;
                    number++;
                }
            }
        
            int x = evaluate(message);
            if(sklenikstav == READY)
            {
                if (x == 0)
                {
                    client.send_all("Neplatny prikaz!\r\n", 18);
                    client.send_all(commandwait, sizeof(commandwait));
                }
                else if (x == 1)
                {
                    char helpmsg[] = "stav\t\t-Zobrazeni aktualnich informaci\r\nset\t\t-Nastaveni skleniku\r\nman\t\t-Ovladani skleniku\r\nexit/quit\t-Konec\r\n";
                    client.send_all(helpmsg, sizeof(helpmsg));
                    client.send_all(commandwait, sizeof(commandwait));
                    number = 0;
                }
                else if (x == 2)
                {
                    state();
                    client.send_all(line1, sizeof(line1));
                    client.send_all(line2, sizeof(line2));
                    client.send_all(line3, sizeof(line3));
                    client.send_all(commandwait, sizeof(commandwait));
                    sklenikstav = READY;
                    number = 0;
                    }
                else if (x == 3)
                {
                    char settings[] = "Prikazy budou doplneny pozdeji - vracim do hlavniho menu\r\n";
                    client.send_all("Nastaveni:\r\n", 12);
                    client.send_all(settings, sizeof(settings));
                    client.send_all(commandwait, sizeof(commandwait));
                    sklenikstav = READY;
                    number = 0;
                }
                else if (x == 4)
                {
                    char manual1[] = "Validni prikazy:\r\nzalij\t\t-Spusti zavlazovani\r\nnezalevej\t-Vypne zavlazovani\r\n";
                    char manual2[] = "ventot\t\t-Otevre ventilaci\r\nventzav\t\t-Zavre ventilaci\r\nvetranizap\t-Zapne vetrak\r\nvetranivyp\t-Vypne vetrak\r\n";
                    char manual3[] = "topzap\t\t-Zapne topeni\r\ntopvyp\t\t-Vypne topeni\r\nsvetlozap\t-Zapne osvetleni\r\nsvetlovyp\t-Vypne osvetleni\r\n";
                    char manual4[] = "zpet\t\t-Navrat do hlavniho menu\r\nexit/quit\t-Konec\r\n";
                    client.send_all("Manualni ovladani\r\n", 19);
                    client.send_all(manual1, sizeof(manual1));
                    client.send_all(manual2, sizeof(manual2));
                    client.send_all(manual3, sizeof(manual3));
                    client.send_all(manual4, sizeof(manual4));
                    client.send_all(commandwait, sizeof(commandwait));
                    sklenikstav = MANUAL;
                    number = 0;
                }
                else
                {
                    break;
                }
            } //break;
                    
            else if(sklenikstav == SETTINGS)
                    sklenikstav = READY;
            else if(sklenikstav == MANUAL)
            {
                if (x == 0)
                {
                    client.send_all("Neplatny prikaz!\r\n", 18);
                    client.send_all(commandwait, sizeof(commandwait));
                }
                else if (x==1)
                {
                    client.send_all("Zalevam\r\n", 9);
                    irrigation.Start();
                    client.send_all(commandwait, sizeof(commandwait));
                }
                else if (x==2)
                {
                    client.send_all("Nezalevam\r\n", 11);
                    irrigation.Stop();
                    client.send_all(commandwait, sizeof(commandwait));
                }
                else if (x==3)
                {
                    client.send_all("Oteviram ventilaci\r\n", 20);
                    ventilation.open();
                    client.send_all(commandwait, sizeof(commandwait));
                }
                else if (x==4)
                {
                    client.send_all("Zaviram ventilaci\r\n", 19);
                    ventilation.close();
                    client.send_all(commandwait, sizeof(commandwait));
                }
                else if (x==5)
                {
                    client.send_all("Spoustim ventilator\r\n", 21);
                    conditioning.Start();
                    client.send_all(commandwait, sizeof(commandwait));
                }
                else if (x==6)
                {
                    client.send_all("Vypinam ventilator\r\n", 20);
                    conditioning.Stop();
                    client.send_all(commandwait, sizeof(commandwait));
                }
                else if (x==7)
                {
                    client.send_all("Spoustim topeni\r\n", 17);
                    heating.Start();
                    client.send_all(commandwait, sizeof(commandwait));
                }
                else if (x==8)
                {
                    heating.Stop();
                    client.send_all("Vypinam topeni\r\n", 16);
                    client.send_all(commandwait, sizeof(commandwait));
                }
                else if (x==9)
                {
                    illumination.Start();
                    client.send_all("Spoustim svetla\r\n", 17);
                    client.send_all(commandwait, sizeof(commandwait));
                }
                else if (x==10)
                {
                    illumination.Stop();
                    client.send_all("Vypinam svetla\r\n", 16);
                    client.send_all(commandwait, sizeof(commandwait));
                }
                else if (x==11)
                {
                    client.send_all(welcomemsg, sizeof(welcomemsg));
                    client.send_all(commandwait, sizeof(commandwait));
                    sklenikstav = READY;
                }
                else
                {
                    break;
                }
            }
        }
        client.send_all("Closing\r\n", 9);
        printf("Closing");
        client.close();
    }
}