#ifndef __PERIPHERALS_H__
#define __PERIPHERALS_H__
/**

*/
class Humid
{
public:
    Humid(PinName AInp = A0, PinName AOut = D0);
    uint8_t readHumidity(void);
    void setLimit(uint8_t lim);
    void setCurrentLimit(void);
    uint8_t getLimit(void);

private:
    AnalogIn   ain;
    DigitalOut dop;
    uint8_t Limit;
};

/**

*/
class Temp
{
public:
    Temp(PinName AInp = A1);
    float readTemperature(void);
    void setHighLimit(float lim);
    void setLowLimit(float lim);
    void setVentLimit(float lim);
    void setCurrentHighLimit(void);
    void setCurrentLowLimit(void);
    void setCurrentVentLimit(void);
    float getHighLimit(void);
    float getLowLimit(void);
    float getVentLimit(void);

private:
    AnalogIn   ain;
    float HLimit, LLimit, VLimit;
};

/**

*/
class Vent
{
public:
    Vent(PinName PWM = D9);
    void open(uint8_t percent = 100);
    void close(void);
    
private:
    PwmOut pwm;
    uint8_t percentage;
};

/**

*/
class Fan
{
public:
    Fan(PinName DOut = D4);
    void Start(void);
    void Stop(void);
private:
    DigitalOut fan;
};

/**

*/
class Heat
{
public:
    Heat(PinName DOut = D5);
    void Start(void);
    void Stop(void);
private:
    DigitalOut heater;
};

/**

*/
class Water
{
public:
    Water(PinName DOut = D6);
    void Start(void);
    void Stop(void);
private:
    DigitalOut sprinkler;
};

/**

*/
class Light
{
public:
    Light(PinName DOut = D7);
    void Start(void);
    void Stop(void);
private:
    DigitalOut lighting;
};

#endif