#include "mbed.h"
#include "Peripherals.h"


Humid::Humid(PinName AInp, PinName AOut):ain(AInp),dop(AOut)
{
    Limit = 110;
    dop = 0;
}

uint8_t Humid::readHumidity(void)
{
    dop = 1;
    wait_ms(10);
    double humidity = 1-ain.read();
    humidity = ((humidity*100)-7)*1.471;
    uint8_t hum = humidity;
    dop = 0;
    return hum;
}

void Humid::setLimit(uint8_t lim)
{
    Limit = lim;
}

void Humid::setCurrentLimit(void)
{
    uint8_t humidity = readHumidity();
    setLimit(humidity);
}

uint8_t Humid::getLimit(void)
{
    return Limit;
}

Temp::Temp(PinName AInp):ain(AInp)
{  
    LLimit = -30;
    HLimit = 125;
    VLimit = 125;
}

float Temp::readTemperature(void)
{
    double voltage, resistance, temperature;
    float temp;
    int resistor = 9910;
    int thermistor = 10000;
    int refTemp = 25;
    int beta = 3380;
    
    voltage = (ain.read())*3.3;
    
    resistance = (voltage*resistor)/(3.3-voltage);
    
    temperature = (log(resistance/thermistor))/beta;
    temperature += 1.0 / (refTemp + 273.15);
    temperature = 1.0 / temperature;
    temperature -= 273.15;
    
    temp = temperature;
    
    return temp;
}

void Temp::setHighLimit(float lim)
{
    HLimit = lim;
}

void Temp::setLowLimit(float lim)
{
    LLimit = lim;
}

void Temp::setVentLimit(float lim)
{
    LLimit = lim;
}

void Temp::setCurrentHighLimit(void)
{
    float temperature = readTemperature();
    setHighLimit(temperature);
}
void Temp::setCurrentLowLimit(void)
{
    float temperature = readTemperature();
    setLowLimit(temperature);
}

void Temp::setCurrentVentLimit(void)
{
    float temperature = readTemperature();
    setVentLimit(temperature);
}

float Temp::getHighLimit(void)
{
    return HLimit;
}

float Temp::getLowLimit(void)
{
    return LLimit;
}

float Temp::getVentLimit(void)
{
    return VLimit;
}


Vent::Vent(PinName PWM):pwm(PWM)
{
    pwm.period(0.020);
    pwm.pulsewidth(0.0009);
    percentage = 0;
}

void Vent::open(uint8_t percent)
{

    uint16_t width = ((6 * percentage)+900);
    
    while(width != (6*percent)+900)
    {
        if(percentage>percent)
        {
            width-=1;
            pwm.pulsewidth_us(width);
            wait_ms(10);
        }
        else
        {
            width+=1;
            pwm.pulsewidth_us(width);
            wait_ms(10);
        }
    }
    percentage = percent;
}

void Vent::close(void)
{
    open(0);
}


Fan::Fan(PinName DOut):fan(DOut)
{
    fan = 0;
}

void Fan::Start(void)
{
    fan = 1;
}
    
void Fan::Stop(void)
{
    fan = 0;
}

Heat::Heat(PinName DOut):heater(DOut)
{
    heater = 0;
}

void Heat::Start(void)
{
    heater = 1;
}
    
void Heat::Stop(void)
{
    heater = 0;
}

Water::Water(PinName DOut):sprinkler(DOut)
{
    sprinkler = 0;
}

void Water::Start(void)
{
    sprinkler = 1;
}
    
void Water::Stop(void)
{
    sprinkler = 0;
}

Light::Light(PinName DOut):lighting(DOut)
{
    lighting = 0;
}

void Light::Start(void)
{
    lighting = 1;
}
    
void Light::Stop(void)
{
    lighting = 0;
}