#include "Autoline.h"
#include "ios.h"

char* allocate_vector(int size) {
    char *aux = (char*)malloc(sizeof(char)*size);
    
    if(aux)
        memset(aux,'\0', sizeof(char)*size);
    
    return aux;    
}

Autoline::Autoline() : pc(USBTX, USBRX) { 
    // Register the parser callback
    connection.registerReadCallback(callback(this,&Autoline::parser));
    
    // Starts on MAINTENANCE_MODE
    state = MAINTENANCE_MODE;
}

Autoline::~Autoline() { }

// It needs a mutex because it's a variable controlled over two threads (ethernet thread and main thread)
void Autoline::set_state(short int newState) {
    _mutex.lock();
    state = newState;
    _mutex.unlock();    
}

void Autoline::print_queue() {
    pc.printf("[AUTOLINE - QUEUE] Queue size: %d\n",queue.size());
    for(int i=0;i<queue.size();i++)
        pc.printf("[AUTOLINE - QUEUE] [%d] - %s\n",i, queue.at(i));
}

void Autoline::protocoler(char *receivedFromEth, int size) {    
    int j = 0;
    bool reading = false;
    
    char local[MAX_SIZE_OF_CMMD];
    memset(local, '\0', sizeof(local));
    
    for(int i=0;i<30;i++) {
        
        // If it received the START of protocol: start to read
        if(receivedFromEth[i] == '{') {
            reading = true;
            continue; 
        }    
        // If it received the END of protocol:
        //      Allocate a char* for the arrived data 
        //      Put everything in the queue and clear the buffer
        else if(reading && receivedFromEth[i] == '}') {
            j = 0;
            reading = false;
            char *aux = allocate_vector(MAX_SIZE_OF_CMMD);
            
            for(int z=0;z<MAX_SIZE_OF_CMMD;z++)
                aux[z] = local[z];
            
            queue.push_back(aux);
            
            memset(local,'\0',sizeof(local));   
        }
        // While reading
        else if(reading) {
            local[j] = receivedFromEth[i];
            j++;    
        }
    }
}

std::string Autoline::read_ios_in_range(int start, int end) {
    std::stringstream sstream;
    std::stringstream aux;
    std::string result;
            
    unsigned long ulong_bits = 0;
            
    // Charlean logic
    for(int i=end;i>=start;i--) {
        ulong_bits = dio.get_ulong(i);                
        aux << std::hex << ulong_bits;
        result = aux.str();
        if(result.size()==1)
            result.push_back('0');
        sstream << result;
    }
        
    return sstream.str();  
}

void Autoline::parser(char *cmmd, int size) {
    //pc.printf("[AUTOLINE - PARSER] -  %s\n",cmmd);
    
    protocoler(cmmd,size);
    
    // Print queue
    //printQueue();
    
    // If there is nothing in the queue, dont need to parse anything
    if(queue.size()==0)
        return;
    
    // Parse command
    switch(queue.at(0)[0]) {
        case CMMD_1: {
            //pc.printf("CMMD 1\n");
            
            // Read the input I/Os (bitset from 0 to 4)
            std::string cmmd1 = read_ios_in_range(0,4);
            cmmd1 = "{1;" + cmmd1 + "}";
            
            pc.printf("CMMD1 - %s\n", cmmd1);
            
            
            // Send through the network
            connection.send((char*)cmmd1.c_str(),cmmd1.size());
            
            break;
        }
        
        case CMMD_2: {
            //pc.printf("CMMD 2\n");
            // { 2 XX Y } -- XX = ADDR of actuator || Y - Status of actuator (0 or 1).
            
            unsigned int x = 0;
            bool status = (queue.at(0)[3] == '1')?true:false;
            char aux[3];
            memset(aux,'\0',sizeof(aux));
            
            aux[0] = queue.at(0)[1];
            aux[1] = queue.at(0)[2];
            
            std::stringstream ss;
            ss << std::hex << aux;
            ss >> x;
            
            pc.printf("[CMMD2] Activating at ADDR: %d as status: %d",x,status);
            dio[x] = status;
            
            break;
        }
        
        //case CMMD_3:
        //    break;
        
        case CMMD_4: {
            //pc.printf("CMMD 4\n");
            
            std::string cmmd4 = read_ios_in_range(5,9);
            cmmd4 = "{4;" + cmmd4 + "}";
            
            // Read the output I/Os (bitset from 5 to 9)
            pc.printf("CMMD4 - %s\n", cmmd4);
            
            // Send through the network
            connection.send((char*)cmmd4.c_str(),cmmd4.size());
            
            break;
        }
        
        case CMMD_5: {
            pc.printf("CMMD 5\n");
            // Enter MAINTENANCE MODE.
            
            set_state(MAINTENANCE_MODE);
            // code here ...
            
            break;
        }
        case CMMD_6: {
            pc.printf("CMMD 6\n");
            // Enter AUTOMATIC MODE.
            
            set_state(AUTOMATIC_MODE);
            // code here ...
            
            break;
        }
        
        case CMMD_7: {
            pc.printf("CMMD 7\n");
            // CMMD 7 - { 7 X } X - ID of station that the test ended.
            // End of test on station X
            
            // code here ...
            break;
        }
        
        case CMMD_S: {
            pc.printf("CMMD S\n");
            // CMMD S - { S X X X X } X - If station is executable or not (1 or 0). 1 for executable, 0 for skip.
            
            // code here ...
            break;   
        }
        
        case CMMD_P: {
            // CMMD P - { P X } X - Enter pause mode or not. (1 or 0). 1 for pause mode 0 to leave pause mode.   
            
            set_state(PAUSED_MODE);
            // code here ...
            
            break;
        }
        
        case CMMD_E: {
            pc.printf("CMMD E\n");
            // CMMD E - { E } - IHM wants to know if CLP is on emergency mode or not.

            // Suggestion done by setting the general state as emergency or not.
            char isEmergencyOn = '0';
            if(state==EMERGENCY_MODE)
                isEmergencyOn = '1';
            
            char cmmde[5];
            memset(cmmde,'\0',sizeof(cmmde));
            cmmde[0] = '{';
            cmmde[1] = 'E';
            cmmde[2] = isEmergencyOn;
            cmmde[3] = '}';
            
            connection.send(cmmde,sizeof(cmmde));
            
            break;
        }

        default: {
            pc.printf("-- UNKOWN COMMAND --\n\t %s",queue.at(0));
            break;
        }
    }
    
    // Delete first item from queue
    if(queue.size()>=1){
        free(queue.at(0));
        queue.erase(queue.begin());    
    }
    
}

// -- MAIN --
void Autoline::run() {
    // General state machine
    switch(state){
        
        case MAINTENANCE_MODE:{
            // code here ...    
        }    
        
        case AUTOMATIC_MODE: {
            // code here ...
            
            // Put all the station's code in here...
            //input_elevator();
            supply_station();    
            //hipot_wait_station();
            //hipot_station();
            //pf_station();
            //ate_wait_station();
            //ate1_station();
            //ate2_station();
            //eprom_station();
            //remove_station();
            //output_elevator();
        }
        
        case EMERGENCY_MODE: {
            // code here ...    
        }
        
        case PAUSED_MODE: {
            // code here ...    
        }
    
    }
    supply_station();
    
    // Put all the stations code in here
}


// EXAMPLE FOR SUPPLY STATION WITHOUT STATE MACHINE
// Coded as it is on google sheets by Matheus Castro
// No state machine yet (might not even be necessary)
void Autoline::supply_station() {
    // In this example there are no else ifs, but there might be in the convyor algorithm.
    // It's important to notice the difference between the IF's logic and the ELSE IF's logic.
    
    // PALLET RELEASE
    if( dio[PS_SUPP] && !dio[PS_WT_HIP] && dio[BT_GO_SUPP] && !dio[SSTOP_SUPP] ) {
        // Do something ...
    }
    
    // STOP LIFTING
    if( !dio[PS_SUPP] || dio[PS_WT_HIP] ) {
        // Do something ...
    }
    
    // IDLE 
    if( (!dio[PS_SUPP] && !dio[SSTOP_SUPP]) || (dio[PS_SUPP] && !dio[BT_GO_SUPP]) ) {
        // Do something ...
    }

}