/* ICTS PLC Board Library
 *
 * PCA9555.cpp
 *
 *  Created on: 24 de mai de 2018
 *      Author: Claudio Pinheiro
 */

#include "PCA9555.h"

PCA9555::PCA9555(I2C *i2cBus, int address) : i2c_bus(i2cBus) {
    i2c_address = FIXED_ADDRESS | ((char)address << 1);
}

PCA9555::~PCA9555() {
    // TODO Auto-generated destructor stub
}

/** Configure the directions of the I/O pins for both
 * port 0 and 1.
 *
 *  @param configPort0  Configuration for Port0
 *  @param configPort1  Configuration for Port1
 */
void PCA9555::configDirAll(char configPort0, char configPort1) {
    cmd[0] = COMMAND_CONFIGURATION_PORT0;
    cmd[1] = configPort0;
    cmd[2] = configPort1;
    i2c_bus->write(i2c_address, cmd, 3);
}

int PCA9555::write(PCA9555_Port_enum port, char value) {
    cmd[0] = COMMAND_OUTPUT_PORT0 + port;
    cmd[1] = value;
    return i2c_bus->write(i2c_address, cmd, 2, false);
}

char PCA9555::read(PCA9555_Port_enum port) {
    cmd[0] = COMMAND_INPUT_PORT0 + port;
    i2c_bus->write(i2c_address, cmd, 1, false);
    if (i2c_bus->read(i2c_address, cmd, 1, false)) {
        return 0xFF;
    }
    return cmd[0];
}

int PCA9555::read(PCA9555_Port_enum port, char *value) {
    int result;
    cmd[0] = COMMAND_INPUT_PORT0 + port;
    result = i2c_bus->write(i2c_address, cmd, 1, false);
    if (result) return result;

    return i2c_bus->read(i2c_address, value, 1, false);
}

int PCA9555::setBit(PCA9555_Port_enum port, char mask) {
    return this->write( port, this->read(port) | mask);
}

int PCA9555::clearBit(PCA9555_Port_enum port, char mask) {
    return this->write( port, this->read(port) & ~mask);
}
