/*
 * Digitalio.h
 *
 *  Created on: Jul 9, 2018
 *      Author: Claudio Pinheiro
 */

#ifndef PLC_DIGITALIO_H_
#define PLC_DIGITALIO_H_

#include <bitset>
#include "PCA9555.h"
#include "mbed.h"

#define SAMPLER_PERIOD_MS 20

struct IO {
    PCA9555 PCA_A;
    PCA9555 PCA_B;
    IO() {};
    IO(I2C *i2cBus, int address1, int address2) : PCA_A(i2cBus, address1), PCA_B(i2cBus, address2) {
        PCA_A.configDirAll(0xFF, 0x00);
        PCA_B.configDirAll(0xFF, 0x00);
    }
    int writeWord(short value) {
        if ( PCA_A.write(PCA9555_PORT1, ~value & 0xFF) ) return 51;;
        if ( PCA_B.write(PCA9555_PORT1, (~value >> 8) & 0xFF) ) return 52;
        return 0;
    }
    int readWord(short *value) {
        char m, l;
        if (PCA_A.read(PCA9555_PORT0, &l)) return 51;
        if (PCA_B.read(PCA9555_PORT0, &m)) return 52;
        *value = ~(l | (m << 8));
        return 0;
    }
};

class DigitalIO {
public:
    DigitalIO();
    virtual ~DigitalIO();

    std::bitset<16>::reference operator[] (std::size_t idx) {
        _mutex.lock();
        return ioBuffer[idx/16][idx & 0xF];
        _mutex.unlock();
    }
    std::bitset<16> const operator[] (std::size_t idx) const {
        return ioBuffer[idx/16][idx & 0xF];
    }

    bool get(std::size_t idx) {
        return ioBuffer[idx/16][idx & 0xF];
    }

    void set(std::size_t idx, bool value = true) {
        ioBuffer[idx/16][idx & 0xF] = value;
    }

    void clear(std::size_t idx, bool value = false) {
        ioBuffer[idx/16][idx & 0xF] = value;
    }

    std::string toString() {
        return ioBuffer[5].to_string<char,std::string::traits_type,std::string::allocator_type>();  
    }
    
    unsigned long get_ulong(std::size_t idx) {
        return ioBuffer[idx].to_ulong();
    }
        
    
private:
    I2C i2cBus1;
    I2C i2cBus2;
    IO *boards[5];
    IO PLC_IO;
    IO EXT0_IO;
    IO EXT1_IO;
    IO EXT2_IO;
    IO EXT3_IO;

    Serial pc;

    std::bitset<16> inBuffer_[5];
//  short inBuffer[5];
    std::bitset<16> outBuffer[5];

    std::bitset<16> ioBuffer[10];

private:
    Ticker inputTicker;
    void inputReader(void);
    Ticker outputTicker;
    void outputWriter(void);

    Mutex _mutex;

};

#endif /* PLC_DIGITALIO_H_ */
