/*
 * Connectivity.cpp
 *
 *  Created on: Jul 16, 2018
 *      Author: Claudio Pinheiro
 */

#include <Connectivity.h>

Connectivity::Connectivity() : thread(osPriorityNormal, 2048), pc(USBTX, USBRX), led_link(LED1) {
    nsapi_error_t result;
    result = eth.set_network(IP, MASK, GATEWAY);
    
    readCallback = NULL;

    if (!result)
        thread.start(callback(this, &Connectivity::monitor));
}

Connectivity::~Connectivity() {
    thread.terminate();
}

int Connectivity::send(char *data, int length) {
    pc.printf("Sending: %s \n", data);
    return client.send(data, length);
}

void Connectivity::registerReadCallback(Callback<void(char*,int)> r) {
    readCallback = r;    
}

void Connectivity::monitor() {
    nsapi_error_t result;

    while (true) {
        pc.printf("Connecting to network...\r\n");
        result = eth.connect();
        if (result == NSAPI_ERROR_OK) {
            pc.printf("Conectado. IP: %s\n\r", eth.get_ip_address());

            srv.open(&eth);
            srv.bind(eth.get_ip_address(), 1200);
            srv.listen(1);

            srv.set_blocking(false);
            client.set_timeout(0);

            while (eth.get_connection_status() == NSAPI_STATUS_GLOBAL_UP) {
                result = srv.accept(&client, &client_addr);
                if (result == NSAPI_ERROR_OK) {
                    pc.printf("Connection accepted from %s\r\n", client_addr.get_ip_address());
                }
                memset(buffer,'\0',sizeof(buffer));
                result = client.recv(buffer, 256);
                
                // Callback
                if (result > 0)
                    readCallback(buffer,sizeof(buffer));
                
            }
        }
        else if (result != NSAPI_ERROR_IS_CONNECTED) {
            eth.disconnect();
        }
    }
}
