#include "mbed.h"

// Our libraries
#include "Connectivity.h"
#include "Digitalio.h"
#include <iostream>
#include <sstream>

#include <vector>
using namespace std;

#ifndef AUTOLINE_AUTOLINE_H_
#define AUTOLINE_AUTOLINE_H_

#define MAX_SIZE_OF_CMMD 5


// General states
#define MAINTENANCE_MODE    0
#define AUTOMATIC_MODE      1
#define EMERGENCY_MODE      2
#define PAUSED_MODE         3


// Autoline's network protocol
#define CMMD_1 '1'      // Read I/Os 0-79 Sensors       - {1}
#define CMMD_2 '2'      // Activate actuator            - {2 XX Y} XX - Actuator ADDR || Y = 1 or 0 (on or off)
//#define CMMD_3 '3'    // Start test (CLP never receives it)
#define CMMD_4 '4'      // Read I/Os 80-179 Actuators   - {4}
#define CMMD_5 '5'      // Enter MAINTENANCE MODE       - {5}
#define CMMD_6 '6'      // Enter AUTOMATIC MODE         - {6}
#define CMMD_7 '7'      // Test finished                - {7 X} X - Station where test has finished (B being the release button on power station)
#define CMMD_S 'S'      // Configure SKIP               - {S X X X X} X - 1 or 0 (1 to do the test, 0 to skip it)
#define CMMD_P 'P'      // Safe pause                   - {P X} x - 1 or 0 (1 to pause, 0 to leave pause)
#define CMMD_E 'E'      // Emergency command            - {E}     - IHM Asks if its on emergency mode or not  

class Autoline {
public:
    Autoline();
    virtual ~Autoline();
    
    
    void run();
    void parser(char *cmmd, int size);
    
private:
    // Attributes
    
    Connectivity connection;
    DigitalIO dio;
    Serial pc;
    
    short int state;            // It could be a char for less memory usage
    
    
    vector<char*> queue;
    
    void protocoler(char *receivedFromEth, int size);
    void print_queue();
    
    std::string read_ios_in_range(int start, int end);
    
    // General functions
    void set_state(short int newState);
    
    // CMMD's functions
    void read_sensors();
    
    // Stations
    void input_elevator();
    void supply_station();
    void hipot_wait_station();
    void hipot_station();
    void pf_station();
    void ate_wait_station();
    void ate1_station();
    void ate2_station();
    void eprom_station();
    void remove_station();
    void output_elevator();
  
    Mutex _mutex;  
};


#endif