#ifndef AUTOLINE_IOS_H_
#define AUTOLINE_IOS_H_


/*
======================= ======= =======================
======================= Sensors =======================
======================= ======= =======================
*/
// INPUT ELEVATOR
#define SUPP_IE         0x00
#define IP_IE           0x01
#define DWS_IP          0x02
#define UPS_IE          0x03
#define SSTOP_IE        0x04
#define DWS_DES_iE      0x05
#define UPS_DES_DE      0x06
// OUTPUT ELEVATOR
#define IP_OE           0x07
#define OP_OE           0x37
#define DWS_OE          0x08
#define UPS_OE          0x09
#define DWS_DES_OE      0x0A
#define UPS_DES_OE      0x0B
// POWER STATION
#define PS_SUPP         0x0E
#define SSTOP_SUPP      0x0F
#define BT_GO_SUPP      0x0C
#define MAN_AUT         0X0D
// WAIT HIPOT
#define PS_WT_HIP       0X10
#define SSTOP_WT_HIP    0x11
// HIPOT
#define PS_HIP          0x12
#define END_DC_HIP      0x13
#define ST_DC_HIP       0x14
#define END_AC_HIP      0x15
#define ST_AC_HIP       0x16
#define SSTOP_HIP       0x17
// PF
#define PS_PF           0x18
#define END_DC_PF       0x19
#define ST_DC_PF        0x1A
#define END_AC_PF       0x1B
#define ST_AC_PF        0x1C
#define SSTOP_PF        0x1D
// WAIT ATE
#define PS_WT_ATE1      0x1E
#define SSTOP_WT_ATE1   0x1F
// ATE1
#define PS_ATE1         0x20
#define GAV1_ATE1       0x21
#define SSTOP_ATE1      0x22
#define UPS_ATE1        0x23
#define DWS_ATE1        0x24
#define END_DC_ATE1     0x25
#define ST_DC_ATE1      0x26
#define END_DC_AC_ATE1  0x27
#define ST_AC_ATE1      0x28
// ATE2
#define PS_ATE2         0x29
#define GAV2_ATE2       0x2A
#define SSTOP_ATE2      0x2B
#define UPS_ATE2        0x2C
#define DWS_ATE2        0x2D
#define END_DC_ATE2     0x2E
#define ST_DC_ATE2      0x2F
#define END_AC_ATE2     0x30
#define ST_AC_ATE2      0x31
// EPROM
#define PS_ROM          0x32
#define SSTOP_ROM       0x35
#define ST_DC_ROM       0x38
#define END_DC_ROM      0x39
// REMOVAL
#define PS_RE           0x33
#define SSTOP_RE        0x34
#define ST_DC_RE        0x3A
#define END_DC_RE       0x3B



/*
======================= ========= =======================
======================= Actuators =======================
======================= ========= =======================
*/
// It sums 0x50 because the OUTPUT I/Os in the bitset start at index 80.

// INPUT ELEVATOR
#define STOP_IE         0x00 + 0x50
#define MT1_FW_IE       0x01 + 0x50
#define MT1_REV_IE      0x3C + 0x50
#define MT2_DW_IE       0x03 + 0x50
#define MT2_UP_IE       0x04 + 0x50
#define FRMT_IE         0x05 + 0x50
// OUTPUT ELEVATOR
#define MT1_FW_OE       0x06 + 0x50
#define MT1_REV_OE      0x07 + 0x50
#define MT2_DW_OE       0x08 + 0x50
#define MT2_UP_OE       0x09 + 0x50
#define FRMT_OE         0x0A + 0x50
// POWER STATION
#define STOP_SUPP       0x0B + 0x50
// WAIT HIPOT
#define STOP_WT_HIP     0x0C + 0x50
// HIPOT
#define SOL_DC_HIP      0x0D + 0x50
#define SOL_AC_HIP      0x0E + 0x50
#define STOP_HIP        0x0F + 0x50
// PF
#define SOL_DC_PF       0x10 + 0x50
#define SOL_AC_PF       0x11 + 0x50
#define STOP_PF         0x12 + 0x50
// WAIT ATE
#define STOP_WT_ATE1    0x13 + 0x50
// RELAY ATE
#define RLADP1_ATE1_2   0x18 + 0x50        // It could be: RLADP1_ATE
#define RLADP2_ATE1_2   0x19 + 0x50        // It could be: RLADP2_ATE
// ATE1
#define SOL_DC_ATE1     0x14 + 0x50
#define SOL_AC_ATE1     0x15 + 0x50
#define STOP_ATE1       0x16 + 0x50
#define SOL1_ELEV_ATE1  0x17 + 0x50
#define MTGAV1_FW_ATE1  0x19 + 0x50
#define MTGAV1_REV_ATE1 0x1A + 0x50
#define MTST_FW_ATE1    0x1B + 0x50
#define MTST_REV_ATE1   0x1C + 0x50
// ATE2
#define SOL_DC_ATE2     0x1D + 0x50
#define SOL_AC_ATE2     0x1E + 0x50
#define STOP_ATE2       0x1F + 0x50
#define SOL1_ELEV_ATE2  0x20 + 0x50
#define MTGAV2_FW_ATE2  0x38 + 0x50
#define MTGAV2_REV_ATE2 0x39 + 0x50
#define MTST_FW_ATE2    0x3A + 0x50
#define MTST_REV_ATE2   0x3B + 0x50
// EPROM
#define STOP_ROM        0x3D + 0x50
#define SOL_ROM         0x3E + 0x50
// Removal
#define STOP_RE         0x30 + 0x50
#define SOL_RE          0x31 + 0x50
// Coneyor
#define MTST_TOP_FW     0x32 + 0x50
#define MTST_BOT_REV    0x33 + 0x50

#endif