/* ICTS PLC Board Library
 *
 * PCA9555.h
 *
 *  Created on: 24 de mai de 2018
 *      Author: Claudio Pinheiro
 */

#ifndef PCA9555_H_
#define PCA9555_H_

#include "mbed.h"

#define FIXED_ADDRESS 0x40

typedef enum {
    PCA9555_PORT0,
    PCA9555_PORT1
} PCA9555_Port_enum;

enum {
    COMMAND_INPUT_PORT0,
    COMMAND_INPUT_PORT1,
    COMMAND_OUTPUT_PORT0,
    COMMAND_OUTPUT_PORT1,
    COMMAND_POL_INVERSION_PORT0,
    COMMAND_POL_INVERSION_PORT1,
    COMMAND_CONFIGURATION_PORT0,
    COMMAND_CONFIGURATION_PORT1
};

class PCA9555 {
public:
    PCA9555() {};

    /* Create interface to PCA9555 IC connected to a given I2C bus
     *
     * @param *i2cBus Pointer to I2C bus
     * @param address PCA9555 bus address
     */
    PCA9555(I2C *i2cBus, int address);

    virtual ~PCA9555();

    /* Configure direction of PCA955 ports
     *
     * @param configPort0 Configuration for Port 0
     * @param configPort1 Configuration for Port 1
     */
    void configDirAll(char configPort0, char configPort1);

    /* Write to a specific port
     *
     * @param port PCA9555 port
     * @param value Value to be writen to port
     */
    int write(PCA9555_Port_enum port, char value);

    char read(PCA9555_Port_enum port);

    int read(PCA9555_Port_enum port, char* value);

    int setBit(PCA9555_Port_enum port, char mask);

    int clearBit(PCA9555_Port_enum port, char mask);

    char getI2CAddress(void) {return i2c_address;};
private:
    I2C *i2c_bus;
    char i2c_address;
    char cmd[3];
};

#endif /* PCA9555_H_ */
