/*
 * Digitalio.cpp
 *
 *  Created on: Jul 9, 2018
 *      Author: Claudio Pinheiro
 */

#include <plc/Digitalio.h>

DigitalIO::DigitalIO() :    i2cBus1(p9, p10),
                            i2cBus2(p28, p27),
                            PLC_IO(&i2cBus1, 0, 1),
                            EXT0_IO(&i2cBus2, 0, 1),
                            EXT1_IO(&i2cBus2, 2, 3),
                            EXT2_IO(&i2cBus2, 4, 5),
                            EXT3_IO(&i2cBus2, 6, 7),
                            pc(USBTX, USBRX)
{
    boards[0] = &PLC_IO;
    boards[1] = &EXT0_IO;
    boards[2] = &EXT1_IO;
    boards[3] = &EXT2_IO;
    boards[4] = &EXT3_IO;

    inputTicker.attach_us(callback(this, &DigitalIO::inputReader), 1000*SAMPLER_PERIOD_MS);
    outputTicker.attach_us(callback(this, &DigitalIO::outputWriter), 1000*SAMPLER_PERIOD_MS);

}

DigitalIO::~DigitalIO() {
    // TODO Auto-generated destructor stub
}

void DigitalIO::inputReader(void) {
    int i;
    short buffer = 0;
    _mutex.lock();
    for (i = 0; i < 5; i++) {
        boards[i]->readWord(&buffer);
        ioBuffer[i] = buffer;
    }
    _mutex.unlock();
}

void DigitalIO::outputWriter(void) {
    int i;
    short buffer = 0;
    _mutex.lock();
    for (i = 0; i < 5; i++) {
        buffer = (short) ioBuffer[5 + i].to_ulong();
        boards[i]->writeWord(buffer);
        //inBuffer_[i] = buffer;
    }
    _mutex.unlock();

}
