/*
 * Connectivity.h
 *
 *  Created on: Jul 16, 2018
 *      Author: Claudio Pinheiro
 */

#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"

#ifndef PLC_CONNECTIVITY_H_
#define PLC_CONNECTIVITY_H_


#define IP "192.168.0.177"
#define MASK "255.255.255.0"
#define GATEWAY "192.168.0.1"

class Connectivity {
public:
    Connectivity();
    virtual ~Connectivity();
    
    int send(char *data, int length);
    void registerReadCallback(Callback<void(char*,int)> r);

private:
    void monitor();
    //void monitor2();

    Thread thread;
    EthernetInterface eth1;
    
    Callback<void(char*,int)> readCallback;
    
    Serial pc;

    void foo(nsapi_event_t event, intptr_t arg);

    DigitalOut led_link;

    EthernetInterface eth;
    TCPServer srv;
    TCPSocket client;
    SocketAddress client_addr;

    char buffer[256];
};

#endif /* PLC_CONNECTIVITY_H_ */
