#ifndef RGB_H
#define RGB_H

#include "mbed.h"
#include "color.h"

/** RGB-Led class
 *  A RGB-LED class to control RGB-Leds
 */ 
class RGB
{
    
    
    public : 
        /** Create RGB instance
         */
        RGB(PinName r_pin, PinName g_pin, PinName b_pin);
        
        /** setColor instance
        *This will set the color
         */
        void setColor(Color*color);
        /** setColor instance with RGB
        *This will set the color with given values red, green, blue
         */
        void setColor(int red, int green, int blue);
        /** setColor instance with integer color
        *This will set the color with given integer
         */
        void setColor(int color);
        
        /** getColor instance
        *This will return the current color in a Color* object
         */
        Color*getColor();
        
        /** Off instance
        *This will turn off all the leds
         */
        void Off();
        
        /** pinNames r_pin declaration
        *Declaration of PinName r_pin
         */
        PinName r_pin;
        /** pinNames b_pin declaration
        *Declaration of PinName b_pin
         */
         PinName b_pin;
         /** pinNames g_pin declaration
        *Declaration of PinName g_pin
         */
        PinName g_pin;
        /** color declaration of type Color*
        *Declaration of Color* color
         */ 
        Color*color;
        /** invertColor instance
        *This will invert every color
         */ 
        void invertColor(Color* color);
        /** PwmOut r_out declaration
        *Declaration of PwmOut r_out
         */
        PwmOut* r_out;
        /** PwmOut b_out declaration
        *Declaration of PwmOut b_out
         */
        PwmOut* b_out;
        /** PwmOut g_out declaration
        *Declaration of PwmOut g_out
         */
        PwmOut* g_out;
        /** static const int MAX_COLOR_VALUE
        *Sets the maximum color value, 255 for RGB
         */
        static const int MAX_COLOR_VALUE = 255;
        
};

#endif