
#include "rgb.h"

RGB::RGB(PinName r_pin, PinName g_pin, PinName b_pin){
    this->r_out = new PwmOut(r_pin);
    this->g_out = new PwmOut(g_pin);
    this->b_out = new PwmOut(b_pin);
}

void RGB::setColor(Color* color){
    this->color = color;
    invertColor(color);
    r_out->write (this->color->getRed());
    g_out->write (this->color->getGreen());
    b_out->write (this->color->getBlue());
}
void RGB::setColor(int red, int green, int blue){
    this->color = new Color(red,green,blue);
}
void RGB::setColor(int color){
    this->color = new Color(color);
    
}
void RGB::invertColor(Color* color){
    this->color = new Color(
        MAX_COLOR_VALUE - color->getRed(),
        MAX_COLOR_VALUE - color->getGreen(),
        MAX_COLOR_VALUE - color->getBlue()
        );
}
void RGB::Off(){
    this->color = new Color(0,0,0);
}

Color* RGB::getColor(){
    return this->color;
}