#ifndef COLOR_H
#define COLOR_H
/** Color class
 *  A Color class to manage the colors, from HEX to RGB or int.
 */ 
class Color
{
    public:
        /** enum of colors
         */
        enum colors { 
            RED= 0xFF0000,
            GREEN = 0x00FF00,
            BLUE = 0x0000FF,
            CYAN = 0x00FFFF,
            MAGENTA = 0xFF00FF,
            YELLOW = 0xFFFFFF,
            WHITE = 0xFFFFFF,
            PINK = 0xFF69B4
        };
        /** Color instance with red, green, blue as integers
         */
        Color(int red, int green, int blue);
        /** Color instance with an integer 
         */
        Color(int color);
        /** Color instance with red, green, blue as floats
         */
        Color(float red, float green, float blue);
        /** getHex method
        *Returns the color as a Hex
         */
        int getHex();
        /** getRed method
        *Returns the color red as an integer
         */
        int getRed();
        /** getGreen method
        *Returns the color green as an integer
         */
        int getGreen();
        /** getBlue method
        *Returns the color blue as an integer
         */
        int getBlue();
    
    private:
        /** Declaration int red
         */
        int red;
        /** Declaration int blue
         */
        int blue;
        /** Declaration int green
         */
        int green;
        /** Declaration int color
         */
        int color;
        /** Declaration method floatToColorValue(float value)
        returns an int
         */
        int floatToColorValue(float value);
        /**Sets the maximum color value, 255 for RGB
         */
        static const int MAX_COLOR_VALUE = 255;
};

#endif