#include "color.h"

Color::Color(int red, int green, int blue){
    this->red = red; 
    this->green = green;
    this->blue = blue;
}

Color::Color(int color){
    red = (color >> 16) & MAX_COLOR_VALUE; // shiften, wsmieten blue & green derut
    green = (color >> 8 ) & MAX_COLOR_VALUE; //shiften, we gooien de blue eruit
    blue = (color >> 0 ) & MAX_COLOR_VALUE;
}

Color::Color(float red, float green, float blue){
    this->red = floatToColorValue(red);
    this->green = floatToColorValue(green);
    this->blue = floatToColorValue(blue);
}
int Color::floatToColorValue(float value){
    return (int) (value * MAX_COLOR_VALUE);
}


int Color::getRed(){
    return red;
}
int Color::getGreen(){
    return green;
}
int Color::getBlue(){
    return blue;
}
int Color::getHex(){
    return (red << 16) + (green << 8) + (blue << 0);
}