#include "mbed.h"
#include "pwmSound_new.h"
//costructor
PwmSound::PwmSound(PinName pin) : _pin(pin) {
    _dutyCycle = 0.5;
    _pin = 0.0;
    _playing = false;
}
void PwmSound::tone(float frequency) {
    _pin.period(1.0f / frequency);
    _pin = _dutyCycle;
    _playing = true;
}

void PwmSound::stop(void) {
    _playing = false;
    _pin = 0.0;
}