#include "mbed.h"
// settings
#define S_MAX 3
#define S_MIN 1.5
// codi
DigitalOut myled(LED1);
//definiamo i nostri imput/autput
DigitalIn segnale_stato_pulsante_sullo_sterzo(D1); //segnale input digitale si puo prendere anche da can)
AnalogIn segnale_stato_del_pedale_del_freno(A0);//segnale input analogico freno (si puo prendere anche da can)
DigitalOut segnale_stato_del_ala_mobile(D0);

float soglia_freno_min = S_MIN; // soglia dia ttivazione freno
float soglia_freno_max = S_MAX;

int main (){
    int stato_pulsante_sullo_sterzo;
    int stato_del_pedale_del_freno;
    int stato_del_ala_mobile;
    //int ripetizione;
    //ora definiamo il nostro programma per il fuzionamento
    //in questo caso abbiamo indentificato un variabile "ripetizione" perche in questo modo il programma puC2 ripetersi all infinito
    while (1){
        /Stato di lettura variabili/
        stato_pulsante_sullo_sterzo = segnale_stato_pulsante_sullo_sterzo;
        if(segnale_stato_del_pedale_del_freno < soglia_freno_min )
            stato_del_pedale_del_freno = 0;
        else if (segnale_stato_del_pedale_del_freno > soglia_freno_max)
            stato_del_pedale_del_freno = 1;
            /Stato di controllo/
        if (stato_del_ala_mobile == 0){
            //funzionamento dato dal volante 1/on
        if (stato_pulsante_sullo_sterzo == 1){
            stato_del_ala_mobile = 1;
                }
            }
            if (stato_del_ala_mobile == 1){
            //definiamo il programma per il funzionamento del freno 1/on
            if (stato_del_pedale_del_freno == 1){
                stato_del_ala_mobile = 0;
            }
        }
        /Stato di esecuzione segnali/
        myled = !myled; //fai lampegiare il led
        segnale_stato_del_ala_mobile = stato_del_ala_mobile;
    }
}
