#include "mbed.h"
#include "MMA8451Q.h"
#include "TSISensor.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void) {
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    PwmOut r(LED_RED);
    PwmOut g(LED_GREEN);
    PwmOut b(LED_BLUE);
     TSISensor tsi;
     

    while (true) {
        float x, y, z ;
        x = abs(acc.getAccX());
        r= 1.0 - (x*tsi.readPercentage());
        y = abs(acc.getAccY());
        g = 1.0 - (y*tsi.readPercentage());
        z = abs(acc.getAccZ());
        b = 1.0 - (z*tsi.readPercentage());
        wait(0.1);
    }
}
