
#include <scmRTOS.h>
#include "mbed.h"
#include <iostream>
#include "TextLCD.h"
//#include "DebounceIn.h"
#include <math.h>
#include <string>
#define MESSAGE_BUFFER_SIZE 1024
#include "time.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "MODSERIAL.h"
#include "stdint.h"
#include "DirHandle.h"
#include "SDCard.h"
#include "mRotaryEncoder.h"

SDCard Logger(p5, p6, p7, p8, "SDCard");
mRotaryEncoder  wheel(p16, p17, p15,PullUp,1500);
Serial Computer(USBTX, USBRX);
DigitalOut LED(LED1);
MODSERIAL gsm(p9,p10);

AnalogIn WindVoltage(p20);
TextLCD lcd(p22, p23, p24, p25, p26, p27); 



char Emergency[40];
char line= '\n';
char c;
char str[40];
char Hi;
struct tm t;
int timecount = 0;
char buffer1[32];
char buf[18];
char buf1[40];
char buf2[4];
char buf3[256];
char buf4[20];
char * pch;
char ctr= 0x1A;
char Key[]="OK";
int Status = 0;
int Status1=0;
int Status2=0;
int Status3=0;
int Status4=0;
int Status5=0;
int Status6=0;
int Status7=0;

float FinalVoltage=0;
char SMS1[] ="#Read Volt\r\n";
char SMS2[] ="#Read Current\r\n";
char SMS3[] ="#Read All\r\n";
char SMS4[] ="#Start Log\r\n";
char SMS5[] ="#Stop Log\r\n";
char SMS6[] ="#Change Emergency\r\n";
char SMS7[] ="#Reset Emergerncy\r\n";
char SMS[15];
int logging =0;
int logon = 0;
int logoff = 0;
int log_set =0;
int log_start = 0;

int counter=0;
int counter1=0;
bool enc_pressed;
bool enc_rotated;


// OS timer/interrupt
OS::TEventFlag GSM;
OS::TEventFlag GSM1;
OS::TEventFlag GSM2;
OS::TEventFlag GSM3;
OS::TEventFlag GSM4;
OS::TEventFlag GSMSTART;
OS::TEventFlag GSMSTOP;
OS::TEventFlag LOGSTOP;
OS::TEventFlag LOGSTART;
//---------------------------------------------------------------------------


void toggle()
{
switch (counter1) {

            default :
              //  wait(0.5);
              lcd.cls();
                lcd.locate(0,0);                    //Default State, Show time normally.
               lcd.printf("%s", buffer1);
                counter1 = 0;
                break;

            case 2 :
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Voltage");

                switch (counter) {
                    case 1 :
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("The Voltage is 3.00V");
                        wait(2);
                        counter=0;
                        break;

                }
                wait(0.5);
                break;


            case 4 :
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Current");

                switch (counter) {
                    case 1 :
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("The Current is 2.34A");
                        wait(2);
                        counter=0;
                        break;

                }
                wait(0.5);
                break;

            case 6 :
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("On log SD card");

                switch (counter) {
                    case 1 :
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Logging commence");
                        wait(2);
                        counter=0;
                        break;

                }
                wait(0.5);
                break;


            case 8 :
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Off log SD card");

                switch (counter) {
                    case 1 :
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Logging aborted");
                        wait(2);
                        counter=0;
                        break;

                }
                wait(0.5);
                break;

            case 10 :
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Reset SMS Alert");

                switch (counter) {
                    case 1 :
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Do you want to reset?");
                        break;
                    case 2 :
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Yes, reset done.");
                        counter=0;
                        break;

                }
                wait(0.5);
                break;

            case 12 :
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Emergency number");

                switch (counter) {
                    case 1 :
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Number:999");
                        wait(5);
                        counter=0;
                        break;

                } 
                wait(0.5);
                break;




        }
}

void trigger_sw() {
    enc_pressed = true;               // just set the flag, rest is done outside isr
}

//interrup-Handler for rotary-encoder rotation
void trigger_rotated() {
    enc_rotated = true;               // just set the flag, rest is done outside isr
}
void Push() {
    if (enc_pressed==true) {
        enc_pressed=false;
        counter++;
    }

}

void Turn() {
    if (enc_rotated == true) {
        enc_rotated = false;

        counter1++;
    }

}

void TimeMessage()    //Get character (e.g. Printf the Words from serial)
    {
        strcpy (str,&Hi);
         do {
            c=Computer.getc();
           Computer.putc (c);
            strcat (str,&c);
            }while (c != ' '); 
    }

void GSM_CLEAR_SMS()      //Delete 1st SMS
{
    gsm.printf("AT+CMGD=0,1\r\n");
    wait(0.2);
}    



void GSM_GETCHAR()    //Get character (e.g. Printf the Words from serial)
{
    do {
    c=gsm.getc();
    Computer.putc (c);
       }while (c != line);
}

void GSM_GETCHAR1()    //Get character (e.g. Printf the Words from serial)
{  
  strcpy (str,&Hi);
    do {
    c=gsm.getc();
     Computer.putc (c);
    strcat (str,&c);
     
       }while (c != line);
        Computer.printf("%s\n\r",str);
    //   Status = strcmp (SMS1,str);
    //   pc.printf("%d\n\r", Status);
       
}

void Replyvolt()
{
    gsm.rxBufferFlush();
    gsm.printf("AT+CMGS=%s\r\n",buf4);        //Send SMS
    GSM_GETCHAR();
    gsm.printf("%s The Voltage is %.2f V  %c", buffer1, FinalVoltage,ctr);    
}

void Replycurent()
{
    gsm.rxBufferFlush();
    gsm.printf("AT+CMGS=%s\r\n",buf4);        //Send SMS
    GSM_GETCHAR();
    gsm.printf("%s The Current is %.2f V  %c", buffer1, FinalVoltage,ctr);    
}

void Replyall()
{
    gsm.rxBufferFlush();
    gsm.printf("AT+CMGS=%s\r\n",buf4);        //Send SMS
    GSM_GETCHAR();
    gsm.printf("%s Voltage: %.2f V, Current: %.2f A   %c", buffer1,FinalVoltage, FinalVoltage,ctr);    
}

void Replylogstart()
{
    gsm.rxBufferFlush();
    gsm.printf("AT+CMGS=%s\r\n",buf4);        //Send SMS
    GSM_GETCHAR();
    if(logging ==1)
    {
   
   gsm.printf(" Logging of SD CARD: Start  %c",ctr);  
     
   GSMSTART.Signal();
    }
    if(logging == 0)
    {
    gsm.printf("%s Logging of SD Card: Has Started since  %c", buffer1, FinalVoltage,ctr);  
    }
    
}

void Replylogstop()
{
    gsm.rxBufferFlush();
    gsm.printf("AT+CMGS=%s\r\n",buf4);        //Send SMS
    GSM_GETCHAR();
    if(logging ==0)
    {
     
    gsm.printf("Logging of SD CARD: Stopped  %c", ctr);  
    GSMSTOP.Signal();
    }
    if(logging == 1)
    {
    gsm.printf("%s Logging of SD Card: Has Stopped since  %c", buffer1,ctr);  
    }
    
}


void CheckSMSMSG()
{
Status1 = strcmp (SMS1,str);
Status2 = strcmp (SMS2,str);
Status3 = strcmp (SMS3,str);
Status4 = strcmp (SMS4,str);
Status5 = strcmp (SMS5,str);
Status6 = strcmp (SMS6,str);
Status7 = strcmp (SMS7,str);

if(Status1 == 0)
{
Replyvolt();
}

if(Status2 == 0)
{
Replycurent();
}

if(Status3 == 0)
{
Replyall();
}
if(Status4 == 0)
{
 GSM3.SignalISR();
}
if(Status5 == 0)
{
 GSM4.SignalISR();
}

if(Status6 == 0)
{
}

if(Status7 == 0)
{
}
else
{
 Computer.printf("Random SMS\n\r");}
}


void GSM_CHECK_MSG() //Check if msg is OK,Error.
{
 Status = strcmp (Key,buf1);
//pc.printf("%d\n\r", Status);            //See the error Number
}



void ExtractNum()  //Extract the number from the sender's sms
{
    pch = strtok (buf3," ,.-");
    pch = strtok (NULL, " ,.-");    
    //pc.printf ("pch is %s\n\r",pch);    //See Number extracted
    strcpy (buf4,pch);  
    Computer.printf("%s\n\r", buf4);                //Number extracted in "+6512345678" 
}



void ReceiveMessage()
{
     gsm.rxBufferFlush();      
     gsm.printf("AT+CMGR=\"1\"\n\r");      //Read Message.
     gsm.scanf("%s",buf);
 
     // pc.printf("%s\r\n",buf); 
     gsm.scanf("%s",buf1);
     //  pc.printf("%s\n\r",buf1);
      
     GSM_CHECK_MSG();                        //Check For reply. If Ok, no sms. if error, no sms.
}


void GSM_STARTUP()
{
 
    gsm.baud(9600); 
     Computer.baud(9600);
    gsm.format(8, Serial::None, 1);
    
    gsm.rxBufferFlush();
    Computer.printf("\n\rSetting Up GSM\n\r");
        Computer.printf("---------------\n\r\n\r");
    gsm.printf("AT+CMGF=\"1\"\r\n");
    gsm.scanf("%s",buf);
 //   pc.printf("buf1 is: %s\r\n",buf);
    
    gsm.scanf("%s",buf3);      //scanf OK
    Computer.printf("%s\r\n",buf3); 
    GSM_CLEAR_SMS();
    do
    { 
    Computer.printf("Enter Emergency Number[Space]: ");
     TimeMessage();
     Computer.printf("\n\r\n\r"); 
    Computer.printf("Is this your Number[y/n]: %s\n\r", str);
     strcpy (Emergency,str); 
       c=Computer.getc();
    Computer.printf("\n\r\n\r"); 
     }while(c !='y');
     Computer.printf("...GSM Setup Done\n\r\n\r\n\r");
      gsm.rxBufferFlush();
}
    
/*void TimeMessage()    //Get character (e.g. Printf the Words from serial)
    {
        strcpy (str,&Hi);
         do {
            c=pc.getc();
            pc.putc (c);
            strcat (str,&c);
            }while (c != ' '); 
    }*/

void time_setup() {
      Computer.baud(9600);
   
    Computer.printf("\n\rSetting Up Time\n\r");
        Computer.printf("---------------\n\r\n\r");

    // get the current time from the terminal

    do{
   Computer.printf("Enter current date and time:\n\r");
   Computer.printf("YYYY MM DD HH MM SS\n\r");    
    
    TimeMessage();
    t.tm_year = atoi (str);
    TimeMessage();
    t.tm_mon = atoi (str);
    TimeMessage();
    t.tm_mday= atoi (str);
    TimeMessage();
    t.tm_hour = atoi (str);
    TimeMessage();
    t.tm_min = atoi (str);
    TimeMessage();
    t.tm_sec = atoi (str);
    
    Computer.printf("\n\r\n\r");
    Computer.printf("Is the time correct [y/n]\n\r");
    c=Computer.getc();
    Computer.printf("\n\r");    
    }while(c !='y');
  
    // adjust for tm structure required values
    t.tm_year = t.tm_year - 1900;
    t.tm_mon = t.tm_mon - 1;
    
    // set the time
    set_time(mktime(&t));
    
    Computer.printf("...Time Setting Done\n\r\n\r");
     
}

void message()    //Get character (e.g. Printf the Words from serial)
{

    do {
    c=Computer.getc();
    Computer.putc (c);
     strcat (str,&c);
     
    }while (c != '.');
    Computer.printf("\n\r\n\r");
    
    
}

void Sending()
{
      if(Status==36)
        {  
        time_t seconds = time(NULL);
        gsm.scanf("%s",buf2);
        gsm.scanf("%s",buf3);                     //Scan ["READ","+6512345678",,"12/01/18,23:54:25+32"]
        ExtractNum();                             //to extract number
    
        Computer.printf("The Message is:\n\r");
        GSM_GETCHAR();  
  
        GSM_GETCHAR1();                           //Compare sms(e.g.SMSing "#ReadVolt" will give u voltage reading)
        GSM_GETCHAR();
               
        GSM_CLEAR_SMS();                         //Delete 1st Message
         gsm.rxBufferFlush();
     
        gsm.rxBufferFlush();
        }
        }
void View_TIME()
{
        do{
        time_t seconds = time(NULL);
        strftime(buffer1, 32, "%a %d/%m/%Y %I:%M:%S %p", localtime(&seconds));
        lcd.printf("%s\n", buffer1);
         wait(1);
         timecount = timecount + 1;
         lcd.cls();
         }while(timecount !=3);
         timecount = 0;
}         
     
void View_Voltage()
{
     do{
       FinalVoltage = WindVoltage * 3.3* 2.926;
        lcd.printf("Voltage: %.2f V", FinalVoltage );  
         wait(1);
         timecount = timecount + 1;
         lcd.cls();  
         }while(timecount != 3);
        timecount = 0;         
}

void SD_card_setup()
{
Computer.printf("\n\rDo you want to start Logging[y/n]:\n\r");
do{
c=Computer.getc();
    if(c=='y')
    {
    logging = 0;
    log_set= 1;
    log_start = 1;
    }
    if(c=='n')
    {
    logging = 1;
    log_set = 1;
    }
  }while(log_set != 1);
}

void SD_CARD()
{     
    if(logging == 0)
    {
   //  Logger.SelectCRCMode(1);
     FILE *fp = fopen("/SDCard/myfile.csv", "a+");
     if(log_start == 1)
      {fprintf(fp,"%s, Logging Start\n\r",buffer1);
      log_start = 0;}
      if(log_start == 2)
      {   fprintf(fp,"%s, Logging Stopped \n\r",buffer1);
      log_start = 0;
      logging = 1;
      }
      else
      {
     fprintf(fp,"%s, Voltage:, %.2f V\n\r",buffer1,FinalVoltage );}
     fclose(fp);
     printf("logging\n\r");
      }
      
}
// process types
typedef OS::process<OS::pr0, 800> TProc1;
typedef OS::process<OS::pr1, 1000> TProc2;
typedef OS::process<OS::pr2, 1500> TProc3;
typedef OS::process<OS::pr3, 1000> TProc4;
typedef OS::process<OS::pr4, 1000> TProc5;
typedef OS::process<OS::pr5, 1000> TProc6;
typedef OS::process<OS::pr6, 1000> TProc7;
typedef OS::process<OS::pr7, 1000> TProc8;
typedef OS::process<OS::pr8, 1000> TProc9;
typedef OS::process<OS::pr9, 1000> TProc10;
typedef OS::process<OS::pr10, 1000> TProc11;
typedef OS::process<OS::pr11, 1000> TProc12;
typedef OS::process<OS::pr12, 1000> TProc13;
typedef OS::process<OS::pr13, 3000> TProc14;

// process objects
TProc1 Proc1;
TProc2 Proc2;
TProc3 Proc3;
TProc4 Proc4;
TProc5 Proc5;
TProc6 Proc6;
TProc7 Proc7;
TProc8 Proc8;
TProc9 Proc9;
TProc10 Proc10;
TProc11 Proc11;
TProc12 Proc12;
TProc13 Proc13;
TProc14 Proc14;



//---------------------------------------------------------------------------


long long count = 0;

int main() {
 Logger.SelectCRCMode(1);
    Computer.baud(9600);
    printf("\nInitialising ...\n");
     gsm.baud(9600);
     
     time_setup();
     GSM_STARTUP();
     SD_card_setup();
     printf("\n\rSAMS Settup Done\n\r");
     wait(0.5);
     printf("\n\rRunning Program\n\r");
      wheel.attachSW(&trigger_sw);
        wheel.attachROT(&trigger_rotated);

   
    OS::Run();
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc1::Exec() {
    for (;;) {
    
    toggle();
    
  //  if(counter == 1)
 //   {
//    printf("Hi\n\r");
 //   }
  Sleep(2000);
      
    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc2::Exec() {
    for (;;) {
    GSM.Wait();
      ReceiveMessage();  
   GSM1.SignalISR();
      Sleep(2000);
      
    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc3::Exec() {
    for (;;) {
        GSM1.Wait();
          Sending();
           gsm.rxBufferFlush();
           GSM2.SignalISR();
      Sleep(2000);
      
      
    }
}
//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc4::Exec() {
    for (;;) {
    if(Status==36){
        GSM2.Wait();
        CheckSMSMSG();                         //Reply SMS
        Computer.printf("Sent SMS\n\r");
        gsm.rxBufferFlush();
         gsm.rxBufferFlush();
          GSM_CLEAR_SMS();
           gsm.rxBufferFlush();}
          
          
      Sleep(2000);
      
      
    }
}
//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc5::Exec() {
    for (;;) {
    
        GSM3.Wait();
         Replylogstart();
       
        Sleep(2000);
      
      
    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc6::Exec() {
    for (;;) {
       
       
        GSM4.Wait();
         Replylogstop();
        Sleep(2000);
      
      
    }
}
//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc7::Exec() {
    for (;;) {
       
       
        GSMSTART.Wait();
        logging = 0;
      //  logon = 1;
        log_start = 1;
        printf("start\n\r");
     //   LOGSTART.Signal();
        Sleep(2000);
      
      
    }
}
//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc8::Exec() {
    for (;;) {
       
       
         GSMSTOP.Wait();
     //   logging = 1;
        log_start = 2;
      //  logon = 1;
        Sleep(2000);
      
      
    }
}
//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc9::Exec() {
    for (;;) {

      LOGSTART.Wait();
      lcd.printf("Logging of SD CARD: Start\n");
    


      Sleep(2000);
    }
    
}




//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc10::Exec() {
    for (;;) {
       
      Sleep(2000);
      
    }
}


//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc11::Exec() {
    for (;;) {
        FinalVoltage = WindVoltage * 3.3* 2.926;
        printf("p2\n\r");
      Sleep(2000);
      
    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc12::Exec() {
    for (;;) {
        
       //Sleep(2000);
     //  lcd.cls();
     //   lcd.printf("Voltage: %.2f\n", FinalVoltage);
     //   printf("[2] %lld\n\r", count);
        Sleep(2000);
      
    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc13::Exec() {
    for (;;) {
 //   LOGSTART.Wait();
 //   SD_CARD();
   // Sleep(1500);
      Sleep(2000);
      
    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc14::Exec() {
    for (;;) {
      printf("SDCARD\n\r");
      SD_CARD();
    Sleep(1500);
      
    }
}
//---------------------------------------------------------------------------
void OS::SystemTimerUserHook() {
  count++;
   if(gsm.rxBufferGetCount() != 0)
    
    { GSM.Signal();}
      time_t seconds = time(NULL);
        strftime(buffer1, 32, "%a %d/%m/%Y %I:%M:%S %p", localtime(&seconds));
        Push();
        Turn();
  wheel.attachSW(&trigger_sw);
    wheel.attachROT(&trigger_rotated);

  
      
     
}

//---------------------------------------------------------------------------
void OS::IdleProcessUserHook() {
    __WFI();
}