#include "mbed.h"
#include "C12832.h"

InterruptIn joystickcenter(p14);
InterruptIn button(p9);
DigitalOut led(LED1);
DigitalOut flash(LED4);
C12832 lcd(p5, p7, p6, p8, p11);
Timer debounce;

int x; //sets variable x to 0
//debounce.start(); // start debounce counting




void flip() {
if (debounce.read_ms() >1000) // if deboucne value is greater that 1 second
{ 
 led = !led; // toggles the led when the joystick button is pressed.
 x=1;  //  sets variable x to 1
// lcd.locate(0,15);
// lcd.printf("DB %.2f", debounce.read());

debounce.reset(); // reset deboucne value
    }
}

void reset()
{
    x=0;
}

int main() {

 joystickcenter.rise(&flip); // attach the function address to the rising edge
 button.mode(PullUp); // With this, no external pullup resistor needed
 button.rise(&flip); // attach the function address to the rising edge
 

 
 while(1) { // wait around, interrupts will interrupt this!
 
  if (x==1){ //if variable 'x' is equivalent to 0
 //lcd.locate(0,0); // Sets location on lcd to 0,0
 //lcd.printf("Variable set to 1");  // Prints Variable set if loop parameter is true
 wait(1); //waits for 1 seconds, to show print on MBED lcd
 //lcd.cls(); //clears lcd screen
 reset();;  //resets x to 0
 }
 
lcd.locate(0,0);
lcd.printf("DB %.2f", debounce.read())
 flash = !flash; // turns LED4 on if off, off if on
 wait(0.25); // the instruction to wait for a quarter-second
 }
 }