  #include "mbed.h"
#include "C12832.h"

InterruptIn joystickcenter(p14);
InterruptIn button(p9);
DigitalOut led(LED1);
DigitalOut flash(LED4);
C12832 lcd(p5, p7, p6, p8, p11);


DigitalIn fire(p14);
PwmOut spkr(p26);
AnalogIn pot1(p19);



int x = 0;
Timer debounce;

void flip() {
 led = !led; // toggles the led when the joystick button is pressed.
 x = 1;
 lcd.printf("debounce = "+debounce.read_ms());
 if(debounce.read_ms()==1)
 {
      lcd.printf("ms 150");
     //assignment
     }
    debounce.reset();
}
int main() {
 
 joystickcenter.rise(&flip); // attach the function address to the rising edge
 button.mode(PullUp); // With this, no external pullup resistor needed
 button.rise(&flip); // attach the function address to the rising edge
 
 while(1) { // wait around, interrupts will interrupt this!
 flash = !flash; // turns LED4 on if off, off if on
 //wait(0.25); // the instruction to wait for a quarter-second
 if(x==1) // check loop
 {
     //lcd.printf("Variable set");
     x = 0;
 }
 
for (float i=2000.0; i<1000.0; i+=100) {
    spkr.period(1.0/i);
    spkr=0.5;
    wait(0.1);
    }
    spkr=0.0;
    while(pot1.read() < 0.0000005) {} // this uses the pot to control the program

 
 
 
 }
 }


//What's needed is a global variable with its own name, for example:
//int x;

//Now, you set x to 1 inside the flip() function. In main(), inside the infinite loop starting with while (1) { , you check whether x ==1 and if it is, you print to the LCD and set x to 0.

//(Be very careful about this. x=1 sets x to 1. x==1 compares x to 1.)