#include "mbed.h"
#include "C12832.h"

InterruptIn joystickcenter(p14);
InterruptIn button(p9);
DigitalOut led(LED1);
DigitalOut flash(LED4);
C12832 lcd(p5, p7, p6, p8, p11);
Timer debounce;

int x; 


void flip() {
 lcd.cls();
 led = !led; // toggles the led when the joystick button is pressed.
 x = 1;
 //wait(0.5);

 if (debounce.read_ms() < 10000){
  //lcd.locate(0,0);
    //lcd.printf("Debounce value: %.3f  \n"+ debounce.read_ms());
 }
     debounce.reset();
}
int main() {
 
 joystickcenter.rise(&flip); // attach the function address to the rising edge
 button.mode(PullUp); // With this, no external pullup resistor needed
 button.rise(&flip); // attach the function address to the rising edge
 
 while(1) { // wait around, interrupts will interrupt this!
 flash = !flash; // turns LED4 on if off, off if on
 wait(0.25); // the instruction to wait for a quarter-second
 if (x==1)
 {
     lcd.printf("Variable set");
     x=0;
}
 }
 }


//What's needed is a global variable with its own name, for example:
//int x;

//Now, you set x to 1 inside the flip() function. In main(), inside the infinite loop starting with while (1) { , you check whether x ==1 and if it is, you print to the LCD and set x to 0.

//(Be very careful about this. x=1 sets x to 1. x==1 compares x to 1.)