#include "mbed.h"
//#include "C12832.h"
#include <iostream> 
#include <math.h>
 
class Shape //Creating class called Shape
{
   protected:
      float width, height, radius; //Creating protcted variables within class Shape
    
    
    public: 
        Shape (float a=0, float b=0, float c=0, float d=0) //assigning values to protected variables in public domain 
        {
        width = a;
        height = b;
        radius = c;
        
        }
        
        virtual int area () // "virtual int.." used as "int.." was setting the variable here and therefore retuning shape areas = 0. The virtual prefix (function?) essential says that int area will be used by another class 
        {
         return 0;
        }
        virtual int perimeter () //Virtual funtions perimeter
        {
         return 0;
        }
};

class Rectangle: public Shape //Creating class rectangle within the class of shape 
    {
        public:
            Rectangle (float a=0, float b=0):Shape(a,b,0) {} 
            int area ()
            {
                return (width*height); //Calculation for rectangle area
            }
            int perimeter ()
            {
                return ((width+height)*2); //Calculation for rectangle perimeter
            }     
    };       
    
class Triangle: public Shape //Creating class triangle within the class of shape 
    {
        public: 
            Triangle(float a=0, float b=0): Shape (a,b,0) {}
            int area ()
                {   
                return (width*height/2); //Calculation for Triangle area
                }
            int perimeter ()
                {
                return width+(2*(sqrt((width/2)*(width/2)+(height*height)))); //Calculation for Triangle perimeter
                //                      2      *    2     +   6   *   6  
                } 
    };

class Circle: public Shape  //Creating class circle within the class of shape 
    {
        public:
            Circle (float c=0): Shape (0,0,c) {} // c is the third calue in the constructor
            int area ()
                {
                return ((radius)*2*3.14); //Calculation for circle area
                }
            int perimeter ()
                {
                return (3.14*radius*radius); //Calculation for rectangle perimeter
                }    
     };

// Main function
int main () 
{
    Shape *Vshape; //Vshape is the pointer towards Shape. shape is how we will draw from the class shape 
    Rectangle rec(3,4); //Assign x and y values for Rectangle
    Triangle  tri(8,3); //Assign x and y values for Triangle
    Circle    cir(5);   //Assign radius values for Circle
    
    
    //Store address if rectangle
    Vshape = &rec;
    
    //Call rectangle and print area 
    Vshape->area(); //Calling Cshapes area function 
    float Rval = Vshape->area(); //Assigning return value to Rval
    printf("Rectangle area is: %.1f\n\r",Rval);  //print value
    Vshape->perimeter();
    float RvalP = Vshape->perimeter();
    printf("Rectangle perimeter is: %.1f\n\n\r",RvalP);


    //Store address if triangle
    Vshape = &tri;
    
    //Call triangle and print area
    Vshape->area(); 
    float Tval = Vshape->area();
    printf("Triangle area is: %.1f\n\r",Tval);
    Vshape->perimeter();
    float TvalP = Vshape->perimeter(); 
    printf("Triangle perimeter is: %.1f\n\n\r",TvalP);


    //Store address if Circle
    Vshape = &cir;

    
    //Call Circle area
    Vshape->area();
    float Cval = Vshape->area();
    printf("Circle area is: %.1f\n\r",Cval);
    Vshape->perimeter();
    float CvalP = Vshape->perimeter(); 
    printf("Circle perimeter is: %.1f\n\n\n\n\r",CvalP);
    
    return 0;

}
