#include "mbed.h"
#include "LM75B.h"
#include "C12832.h"
#include <string>
#include <iostream>
#include <stdio.h>
#include <cstdlib>

C12832 lcd(p5, p7, p6, p8, p11);

LM75B sensor(p28,p27);
Serial pc(USBTX,USBRX);
float TempV; //making a float variable for the temperature value 
float cycles = 300;

LocalFileSystem local("local"); // Create the local filesystem under the name "local"



int main () //Main function ***************************************************************************************
{
    FILE *fp = fopen("/local/temp3.csv", "a");  //Create the file
    fclose (fp);                                //Close the file

// Variables 
    int i =0;
//    int j =0;

    
//while (j<288) //144 5 min cycles in 24 hours *** Main while loop for 3 functions, Writing, reading, displaying 
    
    if (sensor.open()) //Try to open the LM75B
    {
        printf("Device detected!\n\r");        
    }    
    else 
    {
        error("Device not detected!\n");
    }//end if sensor open
        
    fp = fopen("/local/temp3.csv", "a"); //Open the file for writing to    
    
    printf("Measuring temp... \n\r"); //Print confirmation of code running      
    while (i<cycles)
    {
        TempV = (float)sensor; //Temperature is the sensor value 

        fprintf(fp, "%.2f\n", TempV); //print values to file 

        i = i+1; // counter
        wait(1); //Wait 1 seconds to 1*300s = 5 minutes         
            
    } //end while loop for writing function
    fclose (fp);//close the file 
        
    char temps[5]; //Create a string that will contain temerature values from file

        
    fp = fopen("/local/temp3.csv", "r"); //Open rfile for reading 
            
    //min max total
    double num = 0;
    double total = 0;
    double maxtemp = -99.99;
    double mintemp = 99.99;
            
    while (fscanf(fp, "%s", temps)!= EOF) //scan to end of file
    {          
        num = atof(temps); //string to number --> https://os.mbed.com/questions/7171/How-to-convert-String-to-Float-value/
        
        if(num > maxtemp) //Calculating max number
        {
            maxtemp = num;
        }
        
        if(num < mintemp) //Calculating min number
        {
            mintemp = num; 
        }
            
        total = total+ num;

   
    } //while loop creating sting of values from file ends
        double avg = total/(cycles);
        
        printf("Average: %.2f \n\r", avg);
        printf("Max: %.2f \n\r", maxtemp);
        printf("Min: %.2f \n\r", mintemp);
        
        fclose(fp); // close file
    
    //j=j+1 // Controls daily cycle      

}   //end main